/* -*- c++ -*- */
#ifndef AKAXISO2_UTIL_MUTEX_H__
#define AKAXISO2_UTIL_MUTEX_H__

/** 
 * @file akaxiso2/util/mutex.h
 * @brief platform-independent mutex.
 */

#include <akaxiso2/configuration.h>


namespace aka2 {
  /** @brief null-mutex */
  class null_mutex {
  public:
    /** lock */
    void lock() { }
    /** unlock. */
    void unlock() { }
  };
}




#ifdef AKAXISO2_MULTITHREADED

# ifdef AKAXISO2_USE_PTHREAD
#  include <akaxiso2/util/mutex_pthread.h>
namespace aka2 {
  typedef mutex_pthread mutex;
}
# endif

# ifdef _WIN32
#  include <akaxiso2/util/mutex_win32.h>
namespace aka2 {
  typedef mutex_win32 mutex;
}
# endif

#else
namespace aka2 {
  typedef null_mutex mutex;
}
# endif



#endif
