#include "ucs2_traits.h"

using namespace aka2;

/** For UCS-2 */
int ucs2_traits::compare(const uchar_t *lhs, const uchar_t *rhs) {

  while (true) {
    uchar_t diff = *lhs - *rhs;
    if (diff != 0)
      return diff;
    if ((*lhs == 0) && (*rhs == 0))
      return 0;
  }
}

int ucs2_traits::compare(const uchar_t *lhs, const uchar_t *rhs, size_t size) {

  while (size != 0) {
    uchar_t diff = *lhs - *rhs;
    if (diff != 0)
      return diff;
    if ((*lhs == 0) && (*rhs == 0))
      return 0;
    --size;
    ++lhs;
    ++rhs;
  }
  return 0;
}

size_t ucs2_traits::length(const uchar_t *buffer) {
  const uchar_t *scan = buffer;
  while (*scan != 0) {
    ++scan;
  }
  return scan - buffer;
}


int ucs2_traits::find_first(const uchar_t *buffer, size_t size, uchar_t to_find) {
  for (size_t index = 0; index < size; ++index) {
    if (buffer[index] == to_find)
      return index;
  }
  return -1;
}

const char *ucs2_traits::encoding() {
  return "UCS-2";
}
