/* -*- c++ -*- */
#include "encoding_name.h"
#include "../configuration.h"

namespace aka2 {
  extern std::string g_default_encoding_;
  const std::string &get_default_encoding() {
    return g_default_encoding_;
  }
} // namespace aka2


#ifdef _WIN32

#include "win32_transcoder.h"

namespace aka2 {
  extern win32_encodings g_win32_encodings_;
}

#endif /* _WIN32 */


#ifdef AKAXISO2_NL_LANGINFO_SUPPORTED

#include <langinfo.h>

namespace {
  std::string get_langinfo_codepage() {
    const char *codeset = nl_langinfo(AKAXISO2_NL_LANGINFO_CODESET);
    if (codeset)
      return std::string(codeset);
    return std::string();
  }
}

#endif /* AKAXISO2_NL_LANGINFO_SUPPORTED */


#ifdef AKAXISO2_POSIX_LOCALE_SUPPORTED

#include <locale.h>

namespace {
  std::string get_locale_codepage() {
    const char *ctype_str = setlocale(LC_CTYPE, "");
    if (ctype_str == 0)
      return std::string();
    std::string codeset = ctype_str;
    std::string::size_type pos = codeset.find_first_of('.');
    if (pos != std::string::npos) {
      codeset.erase(0, pos + 1); // erase by '.'
    }
    pos = codeset.find_first_of('@');
    if (pos != std::string::npos) {
      codeset.erase(pos); // Check.!!!
    }
    return codeset;
  }
}

#endif /* AKAXISO2_POSIX_LOCALE_SUPPORTED */


void aka2::guess_default_encoding() {
#ifdef _WIN32
  g_default_encoding_ =  g_win32_encodings_.get_default_encoding();
  if (!g_default_encoding_.empty())
    return;
#endif

#ifdef AKAXISO2_POSIX_LOCALE_SUPPORTED
  g_default_encoding_ = get_locale_codepage();
  if (!g_default_encoding_.empty())
    return;
#endif

#ifdef AKAXISO2_NL_LANGINFO_SUPPORTED
  g_default_encoding_ = get_langinfo_codepage();
  if (!g_default_encoding_.empty())
    return;
#endif

  g_default_encoding_ = "US-ASCII";
}
