/* -*- c++ -*- */
#ifndef AKAXISO2_FRAMEWORK_TYPEVECTOR_H__
#define AKAXISO2_FRAMEWORK_TYPEVECTOR_H__

#include <akaxiso2/framework/element_props.h>
#include <algorithm>

namespace aka2 {

  struct element_props_less {
    bool operator()(const qname &name, const element_props *props) const {
      return qname_less()(name, props->get_name());
    }
    bool operator()(const element_props *props, const qname &name) const {
      return qname_less()(props->get_name(), name);
    }
    bool operator()(const element_props *lhs, const element_props *rhs) const {
      return qname_less()(lhs->get_name(), rhs->get_name());
    }
  };

  struct element_props_eq {
    element_props_eq(const aka::qname &name) : name_(name){}
    bool operator()(const element_props &props) const {
      return props.get_name() == name_;
    }
    const qname &name_;
  };

  template<class T> 
  class type_vector {
    typedef std::vector<T> types;
    typedef std::vector<const T*> type_ptrs;
    types originals_;
    type_ptrs sorted_;
    //typedef type_vector<T> THIS_TYPE;

    // hidden copy-ctor.
    type_vector(const type_vector<T> &rhs);
  public:
    explicit type_vector() { }
    typedef TYPENAME types::iterator iterator;
    typedef TYPENAME types::const_iterator const_iterator;

    void clear() {
      originals_.clear();
      sorted_.clear();
    }

    T& back() { return originals_.back(); }

    iterator begin() { return originals_.begin(); }
    iterator end() { return originals_.end(); }
    const_iterator begin() const { return originals_.begin(); }
    const_iterator end() const { return originals_.end(); }

    const T* find(const qname &name) const {
      TYPENAME type_ptrs::const_iterator lb = 
	std::lower_bound(sorted_.begin(), sorted_.end(), 
			 name, element_props_less());
      TYPENAME type_ptrs::const_iterator ub = 
	std::upper_bound(sorted_.begin(), sorted_.end(), 
			 name, element_props_less());
      if (lb == ub)
	return 0;
      assert(lb != sorted_.end());
      return *lb;
    }

    bool add(const T &t) {
      assert(!t.get_name().empty());
      make_sorted_cache();
      const T* found = find(t.get_name());
      bool res = (found == 0);
      originals_.push_back(t);
      return res;
    }

    void make_sorted_cache() {
      sorted_.clear();
      for (TYPENAME types::iterator it = originals_.begin();
	   it != originals_.end(); ++it) {
	sorted_.push_back(&*it);
      }
      std::sort(sorted_.begin(), sorted_.end(), element_props_less());
    }

    bool empty() const {
      return originals_.empty();
    }

  };
  
}

#endif
