/* -*- c++ -*- */
#ifndef AKAXISO2_FRAMEWORK_NAMESPACE_LIST_H__
#define AKAXISO2_FRAMEWORK_NAMESPACE_LIST_H__

#include <akaxiso2/framework/types.h>
#include <vector>

namespace aka2 {

  typedef std::vector<id_type> ns_ids;

  class namespace_list {
    enum wc_ns_type {
      ns_any = 0,
      ns_other,
      ns_uri
    };
    wc_ns_type ns_type_;
    id_type other_target_ns_;
    ns_ids ids_;
  public:
    namespace_list();
    void allow_any();
    void allow_other(const std::string &uri);
    void allow_local();
    void allow_uri(const std::string &uri);
    bool is_name_allowed(const qname &name) const;
  };
}

#endif
