#include "namespace_list.h"
#include "namespace_statics.h"
#include "qname.h"

#include <assert.h>
#include <algorithm>

using namespace aka2;



namespace_list::namespace_list() 
  : ns_type_(ns_any), other_target_ns_(empty_token) { 
}

void namespace_list::allow_any() {
  ns_type_ = ns_any;
}

void namespace_list::allow_other(const std::string &uri) {
  other_target_ns_ = get_namespace_id(uri);
  ns_type_ = ns_other;
}

void namespace_list::allow_local() {
  ids_.push_back(empty_token);
}

void namespace_list::allow_uri(const std::string &uri) {
  ns_type_ = ns_uri;
  id_type ns_id = get_namespace_id(uri);
  ids_.push_back(ns_id);
}

bool namespace_list::is_name_allowed(const qname &name) const {
  switch (ns_type_) {
  case ns_any:
    return true;
  case ns_other:
    if (name.get_namespace_id() == empty_token) /* ##local is not allowed. */
      return false;
    return other_target_ns_ != name.get_namespace_id();
  case ns_uri:
    return std::find(ids_.begin(), ids_.end(), name.get_namespace_id()) != ids_.end();
  }
  assert(!"Must not reach here.");
  return false;
}
