/* -*- c++ -*- */
#ifndef AKAXISO2_FRAMEWORK_ANY_OP_H__
#define AKAXISO2_FRAMEWORK_ANY_OP_H__

#include <akaxiso2/framework/any.h>
#include <akaxiso2/framework/document.h>
#include <assert.h>

namespace aka2 {

  void initialize_any_names();

  struct default_op;

  class wildcard_attributes_op : public element_op {
  public:
    static wildcard_attributes_op dispatcher_;
    static const qname &get_xmltype();
    static void initialize();
    static void uninitialize();

    virtual schematype_id get_schematype() const { return wildcard_attribute_id; }
    virtual const qname &get_typename() const;
    virtual bool equals(const void *lhs, const void *rhs) const;
    
    /** creatable */
    virtual void construct(void *e) const { 
      new (e) wc_attributes();
    }
    virtual void copy_construct(void *e, const void *src) const { 
      new (e) wc_attributes(*static_cast<const wc_attributes*>(src));
    }

    virtual void destruct(void *e) const { assert(!"Must not reach here.");  }

    virtual size_t class_size() const { assert(!"Must not reach here."); return 0; }
    
    /** attribute_info getter. */
    virtual const attribute_types *get_attribute_types() const { 
      assert(!"Must not be called.");
      return 0; 
    }

    virtual const attribute_type *get_anyattr_type() const {
      assert(!"Must not be called.");
      return 0; 
    }

  };



  class wildcard_op : public element_op {
  public:
    static void initialize();
    static void uninitialize();
    static default_op* create_default_op() { return 0; }
    static const qname &get_xmltype();
    static wildcard_op dispatcher_;
    static attribute_type attributes_;

    virtual schematype_id get_schematype() const { return wildcard_id; }
    virtual const qname &get_typename() const;
    /** attribute_types getter. */
    virtual const attribute_types *get_attribute_types() const { 
      return 0; 
    }
    virtual const attribute_type *get_anyattr_type() const {
      return &attributes_;
    }
    virtual bool equals(const void *lhs, const void *rhs) const;

    virtual void construct(void *e) const { new (e) wildcard(); }
    virtual void copy_construct(void *e, const void *src) const { 
      new (e) wildcard(*static_cast<const wildcard*>(src));
    }
    virtual void destruct(void *e) const { 
      static_cast<wildcard*>(e)->~wildcard();
    }
    virtual size_t class_size() const { return sizeof(wildcard); }
  };



  class any_op : public element_op {
  public:
    static void initialize();
    static void uninitialize();
    static const qname &get_xmltype();
    static default_op* create_default_op() { return 0; }
    static any_op dispatcher_;

    virtual schematype_id get_schematype() const { return any_id; }
    virtual const qname &get_typename() const;
    /** attribute_types getter. */
    virtual const attribute_types *get_attribute_types() const { 
      return 0; 
    }
    virtual const attribute_type *get_anyattr_type() const {
      assert(!"Must not be called.");
      return 0;
    }
    virtual bool equals(const void *lhs, const void *rhs) const;

    virtual void construct(void *e) const { new (e) any(); }
    virtual void copy_construct(void *e, const void *src) const { 
      new (e) any(*static_cast<const any*>(src));
    }
    virtual void destruct(void *e) const { 
      static_cast<any*>(e)->~any();
    }
    virtual size_t class_size() const { return sizeof(any); }
  };


  class any_array_op : public element_op {
  public:
    static void initialize();
    static void uninitialize();
    static const qname &get_xmltype();
    static default_op* create_default_op() { return 0; }
    static any_array_op dispatcher_;

    virtual schematype_id get_schematype() const { return any_array_id; }
    virtual const qname &get_typename() const;
    
    /** creatable */
    virtual void construct(void *e) const { new (e) any_array(); }
    virtual void copy_construct(void *e, const void *src) const { 
      new (e) any_array(*static_cast<const any_array*>(src));
    }
    virtual void destruct(void *e) const { 
      static_cast<any_array*>(e)->~any_array();
    }
    virtual size_t class_size() const { return sizeof(any_array); }

    virtual bool equals(const void *lhs, const void *rhs) const;
    
    /** attribute_info getter. */
    virtual const attribute_types *get_attribute_types() const { 
      assert(!"Must not be called.");
      return 0; 
    }
    virtual const attribute_type *get_anyattr_type() const {
      assert(!"Must not be called.");
      return 0; 
    }
  };

}

#endif
