/* -*- c++ -*- */
#ifndef AKAXISO2_SCHEMA_SCHEMA_BUILTIN_XISO_H__
#define AKAXISO2_SCHEMA_SCHEMA_BUILTIN_XISO_H__

/**
 * @file akaxiso2/builtin/schema_builtin_xiso.h
 * @brief leaf classes for XML Schema simplTypes.
 */

#include <akaxiso2/builtin/schema_builtin.h>
#include <akaxiso2/framework/simpletype.h>
#include <akaxiso2/framework/array.h>

#include <set>

namespace xs {

  void initialize_schema_builtins();


  /*
   * xs:integer        integer of unlimited length.
   *                   assigned to LONGLONG.
   * xs:int            4-byte integer (C++'s long)
   * xs:unsignedInt    4-byte unsigned integer (C++'s unsigned long) 
   * xs:long           8-byte integer  LONGLONG
   * xs:unsignedLong   8-byte unsigned integer ULONGLONG
   * xs:short          2-byte integer. (C++'s short)
   * xs:unsignedShort  2-byte integer. (C++'s unsigned short)
   * xs:byte           1-byte integer  (C++'s char)
   * xs:unsignedByte   1-byte unsigned integer (C++'s unsigned char)
   * xs:float          single-presicion 4-bytes real number (C++'s float)
   * xs:double         double-precision 8-bytes real number (C++'s double)
   */

  struct boolean_leaf : public aka2::simpletype<bool, boolean_leaf> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity,
				  aka2::entity_complements &ecomps);
    static void write_text(const void *elm, std::ostream &ostm,
			   aka2::entity_complements &ecomps);
  };

  struct int_leaf : public aka2::simpletype<long, int_leaf> { 
    void model();
  };

  struct unsignedInt_leaf : public aka2::simpletype<unsigned long, unsignedInt_leaf> { 
    void model();
  }; 

  struct long_leaf : public aka2::simpletype<LONGLONG, long_leaf>  {
    void model();
  };

  struct unsignedLong_leaf : public aka2::simpletype<unsigned long, unsignedLong_leaf> {
    void model();
  };

  struct short_leaf : public aka2::simpletype<short, short_leaf> {
    void model();
  };

  struct unsignedShort_leaf : public aka2::simpletype<unsigned short, unsignedShort_leaf> {
    void model();
  };

  typedef xiso::leaf<char> byte_leaf;

  typedef xiso::leaf<unsigned char> unsignedByte_leaf;

  struct float_leaf : public aka2::simpletype<float, float_leaf> {
    void model();
  };

  struct double_leaf : public aka2::simpletype<double, double_leaf> {
    void model();
  };

  struct integer_leaf : public aka2::simpletype<LONGLONG, integer_leaf> {
    void model();
  };

  struct positiveInteger_leaf : public aka2::simpletype<positiveInteger, positiveInteger_leaf> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity,
				  aka2::entity_complements &ecomps);
  };

  struct negativeInteger_leaf : public aka2::simpletype<negativeInteger, negativeInteger_leaf> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity,
				  aka2::entity_complements &ecomps);
  };

  struct nonPositiveInteger_leaf : public aka2::simpletype<nonPositiveInteger, nonPositiveInteger_leaf> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity,
				  aka2::entity_complements &ecomps);
  };

  struct nonNegativeInteger_leaf : public aka2::simpletype<nonNegativeInteger, nonNegativeInteger_leaf> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity,
				  aka2::entity_complements &ecomps);
  };

  struct decimal_leaf : public aka2::simpletype<decimal, decimal_leaf> {
    void model();
  };


  /** Some special cases */

  struct QName_leaf : aka2::simpletype<QName, QName_leaf> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity, 
				  aka2::entity_complements &ecomps);
    static void write_text(const void *elm, std::ostream &ostm,
			   aka2::entity_complements &ecomps);
  };
  
  struct NCName_leaf : aka2::simpletype<NCName, NCName_leaf> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity, 
				  aka2::entity_complements &ecomps);
  };
  
  struct ID_leaf : aka2::simpletype<ID, ID_leaf> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity, 
				  aka2::entity_complements &ecomps);
  };



  /** The following schema types are typedef of std::string. */

  struct base64Binary_leaf : public aka2::simpletype<base64Binary, base64Binary_leaf> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity, 
				  aka2::entity_complements &ecomps);
  };

  struct hexBinary_leaf : public aka2::simpletype<hexBinary, hexBinary_leaf> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity, 
				  aka2::entity_complements &ecomps);
  };

  struct string_leaf : public aka2::simpletype<string, string_leaf> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity, 
				  aka2::entity_complements &ecomps);
  };

  struct normalizedString_leaf : public aka2::simpletype<normalizedString, normalizedString_leaf> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity, 
				  aka2::entity_complements &ecomps);
  };

  struct token_leaf : public aka2::simpletype<token, token_leaf> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity, 
				  aka2::entity_complements &ecomps);
  };

  struct time_leaf : public aka2::simpletype<time, time_leaf> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity, 
				  aka2::entity_complements &ecomps);
  };

  struct dateTime_leaf : public aka2::simpletype<dateTime, dateTime_leaf> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity, 
				  aka2::entity_complements &ecomps);
  };

  struct duration_leaf : public aka2::simpletype<duration, duration_leaf> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity, 
				  aka2::entity_complements &ecomps);
  };

  struct date_leaf : public aka2::simpletype<date, date_leaf> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity, 
				  aka2::entity_complements &ecomps);
  };

  struct gMonth_leaf : public aka2::simpletype<gMonth, gMonth_leaf> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity, 
				  aka2::entity_complements &ecomps);
  };

  struct gYear_leaf : public aka2::simpletype<gYear, gYear_leaf> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity, 
				  aka2::entity_complements &ecomps);
  };

  struct gYearMonth_leaf : public aka2::simpletype<gYearMonth, gYearMonth_leaf> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity, 
				  aka2::entity_complements &ecomps);
  };

  struct gDay_leaf : public aka2::simpletype<gDay, gDay_leaf> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity, 
				  aka2::entity_complements &ecomps);
  };

  struct gMonthDay_leaf : public aka2::simpletype<gMonthDay, gMonthDay_leaf> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity, 
				  aka2::entity_complements &ecomps);
  };

  struct Name_leaf : public aka2::simpletype<Name, Name_leaf> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity, 
				  aka2::entity_complements &ecomps);
  };

  struct anyURI_leaf : public aka2::simpletype<anyURI, anyURI_leaf> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity, 
				  aka2::entity_complements &ecomps);
  };

  struct language_leaf : public aka2::simpletype<language, language_leaf> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity, 
				  aka2::entity_complements &ecomps);
  };

  struct IDREF_leaf : public aka2::simpletype<IDREF, IDREF_leaf> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity, 
				  aka2::entity_complements &ecomps);
  };

  struct IDREFS_leaf : public aka2::simpletype<IDREFS, IDREFS_leaf> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity, 
				  aka2::entity_complements &ecomps);
  };

  struct ENTITY_leaf : public aka2::simpletype<ENTITY, ENTITY_leaf> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity, 
				  aka2::entity_complements &ecomps);
  };

  struct ENTITIES_leaf : public aka2::simpletype<ENTITIES, ENTITIES_leaf> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity, 
				  aka2::entity_complements &ecomps);
  };

  struct NOTATION_leaf : public aka2::simpletype<NOTATION, NOTATION_leaf> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity, 
				  aka2::entity_complements &ecomps);
  };

  struct NMTOKEN_leaf : public aka2::simpletype<NMTOKEN, NMTOKEN_leaf> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity, 
				  aka2::entity_complements &ecomps);
  };

  struct NMTOKENS_leaf : public aka2::simpletype<NMTOKENS, NMTOKENS_leaf> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity, 
				  aka2::entity_complements &ecomps);
  };

  /**
   * arrays
   */

  typedef aka2::sequential_array<base64Binary_array> base64Binary_array_leaf;
  typedef aka2::sequential_array<hexBinary_array> hexBinary_array_leaf;

  typedef aka2::sequential_array<string_array> string_array_leaf;
  typedef aka2::sequential_array<normalizedString_array> normalizedString_array_leaf;
  typedef aka2::sequential_array<token_array> token_array_leaf;

  typedef aka2::sequential_array<positiveInteger_array> positiveInteger_array_leaf;
  typedef aka2::sequential_array<negativeInteger_array> negativeInteger_array_leaf;
  typedef aka2::sequential_array<nonPositiveInteger_array> nonPositiveInteger_array_leaf;
  typedef aka2::sequential_array<nonNegativeInteger_array> nonNegativeInteger_array_leaf;
  typedef aka2::sequential_array<decimal_array> decimal_array_leaf;

  typedef aka2::sequential_array<time_array> time_array_leaf;
  typedef aka2::sequential_array<dateTime_array> dateTime_array_leaf;
  typedef aka2::sequential_array<duration_array> duration_array_leaf;
  typedef aka2::sequential_array<date_array> date_array_leaf;
  typedef aka2::sequential_array<gMonth_array> gMonth_array_leaf;
  typedef aka2::sequential_array<gYear_array> gYear_array_leaf;
  typedef aka2::sequential_array<gYearMonth_array> gYearMonth_array_leaf;
  typedef aka2::sequential_array<gDay_array> gDay_array_leaf;
  typedef aka2::sequential_array<gMonthDay_array> gMonthDay_array_leaf;
  typedef aka2::sequential_array<Name_array> Name_array_leaf;
  typedef aka2::sequential_array<QName_array>  QName_array_leaf;
  typedef aka2::sequential_array<NCName_array> NCName_array_leaf;
  typedef aka2::sequential_array<anyURI_array> anyURI_array_leaf;
  typedef aka2::sequential_array<language_array> language_array_leaf;
  typedef aka2::sequential_array<ID_array, ID_leaf> ID_array_leaf;
  typedef aka2::sequential_array<IDREF_array> IDREF_array_leaf;
  typedef aka2::sequential_array<IDREFS_array> IDREFS_array_leaf;
  typedef aka2::sequential_array<ENTITY_array> ENTITY_array_leaf;
  typedef aka2::sequential_array<ENTITIES_array> ENTITIES_array_leaf;
  typedef aka2::sequential_array<NOTATION_array> NOTATION_array_leaf;
  typedef aka2::sequential_array<NMTOKEN_array> NMTOKEN_array_leaf;
  typedef aka2::sequential_array<NMTOKENS_array> NMTOKENS_array_leaf;
}


namespace xiso {
  template<> struct leaf<xs::QName> : public xs::QName_leaf { };
}

#endif
