/* -*- c++ -*- */
#ifndef XS_SCHEMA_SCHEMA_BUILTIN_H__
#define XS_SCHEMA_SCHEMA_BUILTIN_H__

/**
 * @file akaxiso2/builtin/schema_builtin.h
 * @brief XML Schema simpleTypes.
 */

#include <akaxiso2/framework/qname.h>
#include <vector>

namespace xs {

  /** 
   * short, int, long, float and double are C++ reserved words.
   */

  /**
   * xs:int            4-byte integer (C++'s long)
   * xs:unsignedInt    4-byte unsigned integer (C++'s unsigned long) 
   * xs:long           8-byte integer  LONGLONG
   * xs:unsignedLong   8-byte unsigned integer ULONGLONG
   * xs:short          2-byte integer. (C++'s short)
   * xs:unsignedShort  2-byte integer. (C++'s unsigned short)
   * xs:float          single-presicion 4-bytes real number (C++'s float)
   * xs:double         double-precision 8-bytes real number (C++'s double)
   */


  /** xs:byte : 1-byte integer (-127 ~ 128) */
  typedef char byte;
  /** xs:unsignedByte : 1-byte integer (0 ~ 255) */
  typedef unsigned char unsignedByte;

  /** xs:integer : integer, akaxiso2 assign xs:integer as long */
  typedef long integer; 

  /** xs:positiveInteger : akaxiso2 assigns long. */
  typedef long positiveInteger;
  /** xs:negativeInteger : akaxiso2 assigns long */
  typedef long negativeInteger;
  /** xs:nonPositiveInteger : akaxiso2 assigns long */
  typedef long nonPositiveInteger;
  /** xs:nonNegativeInteger : akaxiso2 assigns long */
  typedef long nonNegativeInteger;
  /** xs:decimal : akaxiso2 assings long */
  typedef long decimal;
  /** xs:boolean : akaxiso2 assigns bool */
  typedef bool boolean;
  /** xs:string : akaxiso2 assigns std::string */
  typedef std::string string;


  // Binary
  typedef std::string base64Binary;
  typedef std::string hexBinary;

  typedef std::string string;
  typedef std::string normalizedString;
  typedef std::string token;


  typedef std::string time;
  typedef std::string dateTime;
  typedef std::string duration;
  typedef std::string date;
  typedef std::string gMonth;
  typedef std::string gYear;
  typedef std::string gYearMonth;
  typedef std::string gDay;
  typedef std::string gMonthDay;
  typedef std::string Name;
  typedef aka2::qname  QName;
  typedef std::string NCName;
  typedef std::string anyURI;
  typedef std::string language;
  typedef std::string ID;
  typedef std::string IDREF;
  typedef std::string IDREFS;
  typedef std::string ENTITY;
  typedef std::string ENTITIES;
  typedef std::string NOTATION;
  typedef std::string NMTOKEN;
  typedef std::string NMTOKENS;

  // arrays
  typedef std::vector<base64Binary> base64Binary_array;
  typedef std::vector<hexBinary> hexBinary_array;

  typedef std::vector<string> string_array;
  typedef std::vector<normalizedString> normalizedString_array;
  typedef std::vector<token> token_array;

  typedef std::vector<positiveInteger> positiveInteger_array;
  typedef std::vector<negativeInteger> negativeInteger_array;
  typedef std::vector<nonPositiveInteger> nonPositiveInteger_array;
  typedef std::vector<nonNegativeInteger> nonNegativeInteger_array;
  typedef std::vector<decimal> decimal_array;

  typedef std::vector<time> time_array;
  typedef std::vector<dateTime> dateTime_array;
  typedef std::vector<duration> duration_array;
  typedef std::vector<date> date_array;
  typedef std::vector<gMonth> gMonth_array;
  typedef std::vector<gYear> gYear_array;
  typedef std::vector<gYearMonth> gYearMonth_array;
  typedef std::vector<gDay> gDay_array;
  typedef std::vector<gMonthDay> gMonthDay_array;
  typedef std::vector<Name> Name_array;
  typedef std::vector<aka2::qname>  QName_array;
  typedef std::vector<NCName> NCName_array;
  typedef std::vector<anyURI> anyURI_array;
  typedef std::vector<language> language_array;
  typedef std::vector<ID> ID_array;
  typedef std::vector<IDREF> IDREF_array;
  typedef std::vector<IDREFS> IDREFS_array;
  typedef std::vector<ENTITY> ENTITY_array;
  typedef std::vector<ENTITIES> ENTITIES_array;
  typedef std::vector<NOTATION> NOTATION_array;
  typedef std::vector<NMTOKEN> NMTOKEN_array;
  typedef std::vector<NMTOKENS> NMTOKENS_array;

}

#endif

