#include "xerces_handler.h"

#ifdef AKAXISO2_USE_XERCESC

#include "xerces_locator.h"

#include "../../framework/document.h"
#include "../../framework/membertype.h"

#include "../deserializer/sequence_handler.h"
#include "../deserializer/choice_handler.h"
#include "../deserializer/simplecontent_handler.h"
#include "../../util/sstream.h"
#include "../../unicode/uniconv.h"

#include <xercesc/sax2/Attributes.hpp>
#include <malloc.h>

using namespace aka2;


xerces_handler::xerces_handler(entity_complements *ecomp)
  : handler_(ecomp) {
  uri_name_.reserve(256);
  localname_.reserve(256);
  value_.reserve(256);
  prefix_.reserve(256);
}


void xerces_handler::startDocument() {
  handler_.reset();
}

void xerces_handler::ucs2_to_pivot(pstring &str, const XMLCh *xstr) {
#if !defined(AKAXISO2_INTERNAL_UCS2)
  tmpbuf_.clear();
  uniconv::ucs2_to_utf8(tmpbuf_, xstr, xercesc::XMLString::stringLen(xstr)) ;
  str.assign(tmpbuf_.get_ptr(), tmpbuf_.get_content_length());
#else
  str.assign(xstr, xercesc::XMLString::stringLen(xstr));
#endif
}


void xerces_handler::convert_to_attributes(const xercesc::Attributes &xattrs, 
					   attribute_values &attrs) {
  for (size_t i = 0; i < xattrs.getLength(); ++i) {
    ucs2_to_pivot(uri_name_, xattrs.getURI(i));
    ucs2_to_pivot(localname_ ,xattrs.getLocalName(i));
    ucs2_to_pivot(value_, xattrs.getValue(i));

    qname name(aka2::pivot, uri_name_, localname_);
    attrs.insert(attribute_values::value_type(name, value_));
  }
}


void xerces_handler::startElement(const XMLCh* const uri, 
				  const XMLCh* const localname, 
				  const XMLCh* const qname, 
				  const xercesc::Attributes& xattrs) {

  //handler_.characters(charsbuf_.get_ptr(), charsbuf_.get_content_length());
  charsbuf_.clear();

  attribute_values attrs;
  convert_to_attributes(xattrs, attrs);

  ucs2_to_pivot(localname_, localname);
  ucs2_to_pivot(uri_name_, uri);

  aka2::qname name(aka2::pivot, uri_name_, localname_);
  handler_.startElement(name, attrs);

}

void xerces_handler::endElement(const XMLCh* const uri, const XMLCh* const localname, const XMLCh* const qname){

  handler_.characters(charsbuf_.get_ptr(), charsbuf_.get_content_length());
  charsbuf_.clear();

  ucs2_to_pivot(localname_, localname);
  ucs2_to_pivot(uri_name_, uri);

  aka2::qname name(aka2::pivot, uri_name_, localname_);
  handler_.endElement(name);
}

void xerces_handler::characters(const   XMLCh* const    chars, 
				const unsigned int    length){
#if !defined(AKAXISO2_INTERNAL_UCS2)
  uniconv::ucs2_to_utf8(charsbuf_, chars, length);
#else
  charsbuf_.append(chars, length);
#endif

}


void xerces_handler::setDocumentLocator(const xercesc::Locator* const locator) {
  xerces_locator *xloc = new xerces_locator(locator);
  handler_.set_locator(xloc);
}

document xerces_handler::get_document() {
  return handler_.get_document();
}


void xerces_handler::startPrefixMapping(const XMLCh* const  prefix, const XMLCh* const  uri) {
  ucs2_to_pivot(prefix_, prefix);
  ucs2_to_pivot(uri_name_, uri);
  handler_.start_prefix_mapping(prefix_, uri_name_);
}

void xerces_handler::endPrefixMapping(const XMLCh* const  prefix) {
  ucs2_to_pivot(prefix_, prefix);
  handler_.end_prefix_mapping(prefix_);
}

void xerces_handler::error(const xercesc::SAXParseException& e) {
}

void xerces_handler::fatalError(const xercesc::SAXParseException& e) {
  std::ostringstream error;
  error << handler_.get_context().get_source_name() 
	<< ':' << e.getLineNumber() << ':' << e.getColumnNumber()
	<< ' ' << XMLCh_to_chars(e.getMessage()).str();
  throw aka2::error(error.rdbuf()->str(), __FILE__, __LINE__);
}

void xerces_handler::warning(const xercesc::SAXParseException& e) {
}



#endif // AKAXISO2_USE_XERCESC
