/* -*- c++ -*- */
#ifndef AKAXISO2_XML_SERIALIZER_XML_SERIALIZERS_H__
#define AKAXISO2_XML_SERIALIZER_XML_SERIALIZERS_H__

/** 
 * @file akaxiso2/XML/serializer/xml_serializers.h
 * @brief XML serializer declarations.
 */

#include <akaxiso2/configuration.h>
#include <akaxiso2/exception.h>
#include <akaxiso2/XML/serializer/xml_serializer.h>

namespace aka2 {

  /**
   * @brief XML serializer for UTF-8.
   *
   * default_serializer uses aka2::default_fomatter.
   * This is the simplest XML serializer without encoding translation.
   */
  class utf8_serializer : public xml_serializer {
  public:
    utf8_serializer();
  };

} // namespace aka2


#ifdef AKAXISO2_USE_ICU

namespace aka2 {

  /** @brief XML serializer with ICU transcoder. */
  class icu_serializer : public xml_serializer {
  public:
    icu_serializer(const std::string &encoding = std::string());
  };

} // namespace aka2

#endif


#ifdef AKAXISO2_USE_ICONV

namespace aka2 {

  /** @brief XML serializer with ICU transcoder. */
  class iconv_serializer : public xml_serializer {
  public:
    iconv_serializer(const std::string &encoding = std::string());
  };

} // namespace aka2

#endif


#ifdef _WIN32

namespace aka2 {

  /** @brief XML serializer with Win32/MLang transcoder. */
  class win32_serializer : public xml_serializer {
  public:
    win32_serializer(const std::string &encoding = std::string());
  };

}

#endif

#endif
