/* -*- c++ -*- */
#ifndef AKAXISO2_XML_DESERIALIZER_XML_DESERIALIZERS_H__
#define AKAXISO2_XML_DESERIALIZER_XML_DESERIALIZERS_H__

/** 
 * @file akaxiso2/XML/deserializer/xml_deserializers.h
 * @brief declarations of xml_deserializers.
 */

#include <akaxiso2/configuration.h>


#ifdef AKAXISO2_USE_XERCESC
#include <memory.h> /* {BCB6} */
#include <akaxiso2/XML/xerces/xerces_deserializer.h>

namespace aka2 {
  /**
   * @class xml_deserializer
   * @brief The default XML deserializer class of akaxiso library.
   *
   * The xml_deserializer is typedef'ed according to the following rules.\n
   * Rule1. If Xerces-C++ is enabled, xml_deserializer is the typedef name 
   * of aka2::xerces_deserializer.\n
   * Rule2. If Xerces-C++ is diabled, xml_deserializer is 
   * the typedef name of aka2::expat_deserializer.\n
   */
  
  typedef xerces_deserializer xml_deserializer;
}

# define AKAXISO2_DEFAULT_PARSER "Xerces-C++"

#endif


#ifdef AKAXISO2_USE_EXPAT
# include <akaxiso2/XML/expat/expat_deserializer.h>
# if !defined(AKAXISO2_DEFAULT_PARSER)
#  define AKAXISO2_DEFAULT_PARSER "expat"
namespace aka2 {
  typedef expat_deserializer xml_deserializer;
}
# endif
#endif

#endif

