#include "simpletype_handler.h"
#include "../../util/sstream.h"

#include <cassert>

using namespace aka2;


simpletype_handler::simpletype_handler(void *e, 	
				       const simpletype_op &sop, 
				       int depth,
				       const element_props &props,
				       parser_context &context) 
  : handler(false, depth, props, context), elm_(e), sop_(sop) {}


validation_result simpletype_handler::query_element(const qname &tagname, 
					       const attribute_values &attrs) {
  return invalid;
}

validation_result simpletype_handler::query_next(const qname &tagname, 
					       const attribute_values &attrs) {
  assert(!"Must not be called.");
  return ok;
}


validation_result simpletype_handler::end_element(const qname &tagname){
  return ok;
}

bool simpletype_handler::parse_entity(const pstring &entity) {
  try {
    sop_.read_unicode_text(elm_, entity, context_.get_entity_complements());
    return true;
  }
  catch ( const std::exception &e ) {
    context_.report(e.what(), __FILE__, __LINE__);
  }
  catch ( ... ) {
    context_.report("Unhandled parse error on parsing entity.", __FILE__, __LINE__);
  }
  return false;
}


// Mainly used for choices.
node simpletype_handler::get_node(){
  return node(elm_, sop_);
}

void simpletype_handler::receive_child(const node &child){
  assert(!"Must not be called.");
  assert(&sop_ == &child.op());
}

bool simpletype_handler::can_skip() {
  return false;
}

void simpletype_handler::abort() {
}
