//CUPPA:include=+
//CUPPA:include=-
#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/TestAssert.h>

#include <akaxiso2/akaxiso2.h>
#include <akaxiso2/content_model.h>

//CUPPA:namespace=+
//CUPPA:namespace=-


class simpleTypeTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(simpleTypeTest);
//CUPPA:suite=+
  CPPUNIT_TEST(test_parse_fixed);
  CPPUNIT_TEST(test_parse_wrong_fixed);
//CUPPA:suite=-
  CPPUNIT_TEST_SUITE_END();
private:

public:

  virtual void setUp() { 
    aka2::initialize();
    aka2::doctype("fixed", xiso::leaf<std::string>(), "test");
  }

  virtual void tearDown(){
    aka2::uninitialize();
  }

//CUPPA:decl=+
  void test_parse_fixed() {
    aka::document doc = aka2::deserialize("<?xml version=\"1.0\"?><fixed>test</fixed>");
    std::string *str = aka::root_cast<std::string>(doc);
    CPPUNIT_ASSERT_MESSAGE("wrong root node value.", *str == "test");
  }
  void test_parse_wrong_fixed() {
    try {
      aka2::deserialize("<?xml version=\"1.0\"?><fixed>test__</fixed>");
    }
    catch (const std::exception &) {
    }
  }

//CUPPA:decl=-
};

//CUPPA:impl=+
//CUPPA:impl=-

CPPUNIT_TEST_SUITE_REGISTRATION(simpleTypeTest);
