//CUPPA:include=+
#include <akaxiso2/akaxiso2.h>
#include <akaxiso2/content_model.h>
//CUPPA:include=-
#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/TestAssert.h>

//CUPPA:namespace=+
//CUPPA:namespace=-

namespace {

  struct ns1_any {
    aka::any any_;
  };

  struct ns1_any_leaf : aka::sequence<ns1_any, ns1_any_leaf> {
    void model() {
      any("&any", &ns1_any::any_, "##any");
    }
  };

  struct ns1_other {
    aka::any any_;
  };

  struct ns1_other_leaf : aka::sequence<ns1_other, ns1_other_leaf> {
    void model() {
      any("&any", &ns1_other::any_, "##other:testns1");
    }
  };

  struct ns1_ns2 {
    aka::any any_;
  };

  struct ns1_ns2_leaf : aka::sequence<ns1_ns2, ns1_ns2_leaf> {
    void model() {
      any("&any", &ns1_ns2::any_, "testns2");
    }
  };

  void initialize() {
    aka::initialize();
    aka::xmlns("ns1", "testns1");
    aka::xmlns("ns2", "testns2");

    aka::doctype("ns1:any", ns1_any_leaf());
    aka::doctype("ns1:other", ns1_other_leaf());
    aka::doctype("ns1:ns2", ns1_ns2_leaf());
    aka::doctype("ns1:str", xiso::leaf<std::string>());
    aka::doctype("ns2:str", xiso::leaf<std::string>());
  }

  void uninitialize() {
    aka::uninitialize();
  }

}


class anyDocumentTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(anyDocumentTest);
//CUPPA:suite=+
  CPPUNIT_TEST(test_any_doc1);
  CPPUNIT_TEST(test_any_doc2);
  CPPUNIT_TEST(test_other_doc1);
  CPPUNIT_TEST(test_other_doc2);
  CPPUNIT_TEST(test_ns2_doc1);
  CPPUNIT_TEST(test_ns2_doc2);
//CUPPA:suite=-
  CPPUNIT_TEST_SUITE_END();
private:

  // your stuff...

public:

  virtual void setUp() { 
    initialize();
  }
  virtual void tearDown() {
    uninitialize();
  }

//CUPPA:decl=+
  void test_any_doc1() {
    const char *doc = 
      "<?xml version=\"1.0\"?>\n"
      "<ns1:any xmlns:ns1=\"testns1\">\n"
      "  <ns1:str>test</ns1:str>\n"
      "</ns1:any>\n";
    aka::deserialize(doc);
  }
  void test_any_doc2() {
    const char *doc = 
      "<?xml version=\"1.0\"?>\n"
      "<ns1:any xmlns:ns1=\"testns1\">\n"
      "  <ns2:str xmlns:ns2=\"testns2\">test</ns2:str>\n"
      "</ns1:any>\n";
    aka::deserialize(doc);
  }
  void test_other_doc1() {
    const char *doc = 
      "<?xml version=\"1.0\"?>\n"
      "<ns1:other xmlns:ns1=\"testns1\">\n"
      "  <ns1:str>test</ns1:str>\n"
      "</ns1:other>\n";

    bool err = false;
    try {
      aka::deserialize(doc);
    }
    catch ( const std::exception & ) {
      err = true;
    }
    CPPUNIT_ASSERT_MESSAGE("Parse error not thrown.", err);
  }
  void test_other_doc2() {
    const char *doc = 
      "<?xml version=\"1.0\"?>\n"
      "<ns1:other xmlns:ns1=\"testns1\">\n"
      "  <ns2:str  xmlns:ns2=\"testns2\">test</ns2:str>\n"
      "</ns1:other>\n";
    aka::deserialize(doc);
  }

  void test_ns2_doc1() {
    const char *doc = 
      "<?xml version=\"1.0\"?>\n"
      "<ns1:ns2 xmlns:ns1=\"testns1\">\n"
      "  <ns1:str>test</ns1:str>\n"
      "</ns1:ns2>\n";

    bool err = false;
    try {
      aka::deserialize(doc);
    }
    catch ( const std::exception & ) {
      err = true;
    }
    CPPUNIT_ASSERT_MESSAGE("Parse error not thrown.", err);
  }
  void test_ns2_doc2() {
    const char *doc = 
      "<?xml version=\"1.0\"?>\n"
      "<ns1:ns2 xmlns:ns1=\"testns1\">\n"
      "  <ns2:str xmlns:ns2=\"testns2\">test</ns2:str>\n"
      "</ns1:ns2>\n";
    aka::deserialize(doc);
  }



//CUPPA:decl=-
};

//CUPPA:impl=+
//CUPPA:impl=-

CPPUNIT_TEST_SUITE_REGISTRATION(anyDocumentTest);
