/* -*- c++ -*- */
#ifndef OSIXAKA2_REGISTRY_H__
#define OSIXAKA2_REGISTRY_H__

#include <akaxiso2/akaxiso2.h>
#include <osixaka2/classdefs.h>
#include <osixaka2/name_resolver.h>

namespace xs {
  struct schema;
}

namespace osp {
  struct preference;
}

namespace osx {

  struct unit_props {
    unit_props() 
      : target_ns_id_(aka::empty_token) { }
    unit_props(xs::schema *schema, aka::id_type target_ns_id, 
	       const std::string &basename, const std::string &filename) 
      : schema_(schema), target_ns_id_(target_ns_id), 
	basename_(basename), filename_(filename) { }
    xs::schema *schema_;
    aka::id_type target_ns_id_;
    std::string basename_;
    std::string filename_;
  };

  struct unit_props_less {
    bool operator()(const unit_props &lhs, const unit_props &rhs) const {
      return lhs.target_ns_id_ < rhs.target_ns_id_;
    }
  };

  typedef std::vector<unit_props> unit_array;

  class registry_unit {
  public:
    registry_unit(aka::id_type target_ns_id) : target_ns_id_(target_ns_id) { }

    qname_set toplevels_;
    attrGroup_defs attributeGroups_;
    gattribute_defs gattributes_;
    element_defs elements_;
    name_resolver simpleTypes_;
    class_defs classes_;
    aka::id_type target_ns_id_;

    bool type_exists(const aka::qname &type) const;
    bool name_exists(const aka::qname &name) const;
    bool is_toplevel(const aka::qname &name) const;
  };

  typedef std::vector<registry_unit*> registry_units;

  class registry {
    osp::preference *preference_;
    static std::string to_cppname(const std::string &name);
    name_resolver predefinedSimpleTypes_;
    registry_units registry_units_;
  public:
    registry() : preference_(0) { }
    ~registry();

    unit_array units_;
    registry_unit &operator[](const unit_props &unit); 

    bool type_exists(const aka::qname &type) const;
    bool name_exists(const aka::qname &name) const;
    bool is_processed(const std::string &simplified_path) const;

    const gattribute_def &get_globalAttribute(const aka::qname &name) const;
    bool attributeGroup_exists(const aka::qname &name) const;
    const attributeGroup_def &attributeGroup_get(const aka::qname &name) const;
    //   name_resolver elements_;
    //   name_resolver simpleTypes_;
    //   class_defs classes_;

    bool classdef_exists(const aka::qname &name);
    class_def &classdef_get(const aka::qname &name);

    bool simpleType_exists(const aka::qname &name);

    bool is_toplevel(const aka::qname &name) const;
  
    /**
     * Preference related methods.
     */
    aka::qname rename_type(const aka::qname &type) const;

    void insert_simpleTypes();

    void get_predefinedTypes(qname_set &resolved) const;
    bool is_predefined(const aka::qname &name) const;
    aka::qname resolve_predefinedType(const aka::qname &name) const;
    bool is_xs_any(const aka::qname &type) const;
    bool is_aka_any(const aka::qname &type) const;
    bool is_builtin(const aka::qname &type) const;

    std::string get_predefined_leafname(const aka::qname &name) const;
    aka::qname get_predefined_array(const aka::qname &name) const;

    std::string escape(const std::string &to_escape) const;


    void load_defaults();
    void load_osixaka1_defaults();
    void save_preference(std::ostream &ostm);
    void load_preference(const std::string &filename);
    void register_ns();

    const std::string &choice_container_type() const;
    const std::string &array_container_type() const;
    const std::string &simplecontent_value_name() const;
    const std::string &get_member_prefix() const;
    const std::string &get_member_suffix() const;
    const std::string &get_array_prefix() const;
    const std::string &get_array_suffix() const;
    const std::string &get_nill_type() const;
  };
}
#endif
