/* -*- c++ -*- */
#ifndef OSIXAKA2_H__
#define OSIXAKA2_H__

#include <akaxiso2/akaxiso2.h>
#include <osixaka2/registry.h>
#include <osixaka2/exception.h>

namespace osx {

  class osixaka2 {
    std::ostream &ostm_;
    bool use_soft_array_;
    bool verbose_;

    registry registry_;

    void generate_all_in_one(const std::string &outputdir);
    void generate_target_ns(const std::string &outputdir);
  public:
    osixaka2(std::ostream &ostm, bool use_soft_array, bool verbose)
      : ostm_(ostm), use_soft_array_(use_soft_array), verbose_(verbose) {}

    int preprocess(const std::string &filepath, bool generate_deps);
    int process();
    int akaxisonize(int level);
    int generate(const std::string &outputdir, bool one_ns);
    int generate_functions(const std::string &outputdir, const std::string &filename);
    int dump_schemas(std::ostream &ostm) const;
    int generate_dot(const std::string &outputdir);
    int process_dtd(const std::string &filepath);

    // Preference-related methods.
    static void initialize();
    void reset();
    void load_defaults();
    void load_osixaka1_defaults();
    void load_preference(const std::string &filename);
    void save_preference(std::ostream &file);
  };
}

#endif
