/* -*- c++ -*- */
#ifndef OSIXAKA2_DOT_GENERATOR_H__
#define OSIXAKA2_DOT_GENERATOR_H__

#include <akaxiso2/akaxiso2.h>
#include <osixaka2/classdefs.h>
#include <osixaka2/registry.h>
#include <fstream>

namespace osx {

  class dot_generator {
    registry &registry_;
    std::ostream &ostm_;
    qname_set generated_;
    void generate_for_unit(const unit_props &unit);
    void begin_dot_file();
    void end_dot_file();

    void generate_tree(const aka::qname &type);
    void write_dir(const aka::qname &start_edge, const aka::qname &end_edge);

    void generate_sequence(const class_def &def);
    void generate_choice(const class_def &def);
    void generate_all(const class_def &def);
    void generate_array(const class_def &def);
    void generate_simplecontent(const class_def &def);
    void generate_simpletype(const class_def &def);
    std::string escape(const aka::qname &to_escape) const;
    static std::string quote(const aka::qname &to_quote);

    typedef std::map<aka::qname, long, aka::qname_less> end_edges;
    typedef std::map<aka::qname, end_edges, aka::qname_less> edges;
    edges edges_;
  public:
    dot_generator(registry &reg, std::ostream &ostm) 
      : registry_(reg), ostm_(ostm) { }
    void generate();
  };

}

#endif
