#include "dot_generator.h"
#include <akaxiso2/util/string_funcs.h>

using namespace osx;

void dot_generator::begin_dot_file() {
  ostm_ << "#!/usr/local/bin/dot" << std::endl
	<< std::endl
	<< "digraph G {" << std::endl
	<< "rankdir=LR;" << std::endl;
}

void dot_generator::end_dot_file() {
  ostm_ << "}" << std::endl;
}

std::string dot_generator::escape(const aka::qname &to_escape) const {
  std::string escaped = registry_.escape(to_escape.qualified());
  for (std::string::iterator it = escaped.begin(); 
       it != escaped.end(); ++it)
    if (*it == ':')
      *it = '_';
  return escaped;
}

std::string dot_generator::quote(const aka::qname &to_quote) {
  return aka::quote(to_quote.qualified());
}

void dot_generator::write_dir(const aka::qname &start_edge, const aka::qname &end_edge) {
  if (edges_[start_edge][end_edge] == 0) {
    ostm_ << escape(start_edge) << " -> " << escape(end_edge) << ";" << std::endl;
    edges_[start_edge][end_edge] = 1;
  }
}


void dot_generator::generate_sequence(const class_def &def) {
  ostm_ << escape(def.get_name()) << " [label=" << quote(def.get_name()) << "];" << std::endl;
  for (element_types::const_iterator eit = def.etypes_.begin();
       eit != def.etypes_.end(); ++eit) {
    write_dir(def.get_name(), eit->type_);
    generate_tree(eit->type_);
  }
}

void dot_generator::generate_choice(const class_def &def) {
  ostm_ << escape(def.get_name()) << " [label=" << quote(def.get_name()) << "];" << std::endl;
  for (element_types::const_iterator eit = def.etypes_.begin();
       eit != def.etypes_.end(); ++eit) {
    write_dir(def.get_name(), eit->type_);
    generate_tree(eit->type_);
  }
}

void dot_generator::generate_all(const class_def &def) {
  ostm_ << escape(def.get_name()) << " [label=" << quote(def.get_name()) << "];" << std::endl;
  for (element_types::const_iterator eit = def.etypes_.begin();
       eit != def.etypes_.end(); ++eit) {
    write_dir(def.get_name(), eit->type_);
    generate_tree(eit->type_);
  }
}

void dot_generator::generate_array(const class_def &def) {
  write_dir(def.get_name(), def.get_value_type());
  ostm_ << escape(def.get_name()) << " [label=" << quote(def.get_name()) << "];" << std::endl;
  generate_tree(def.get_value_type());
}

void dot_generator::generate_simplecontent(const class_def &def) {
//   ostm_ << def.get_name() << " -> " << def.get_value_type() << ";" << std::endl;
//   generate_tree(def.get_value_type());
}

void dot_generator::generate_simpletype(const class_def &def) {
//   ostm_ << def.get_name() << ";" << std::endl;
}

void dot_generator::generate_tree(const aka::qname &type) {

  if (generated_.find(type) != generated_.end())
    return;

  if (registry_.is_predefined(type))
    return;

  const class_def &def = registry_.classdef_get(type);
  generated_.insert(def.get_name());

  if (def.id_ == simpletype_id)
    return;

  switch (def.id_) {
  case sequence_id:
    generate_sequence(def);
    break;
  case choice_id:
    generate_choice(def);
    break;
  case all_id:
    generate_all(def);
    break;
  case simplecontent_id:
    generate_simplecontent(def);
    break;
  case simpletype_id:
    generate_simpletype(def);
    break;
  case array_id:
    generate_array(def);
    break;
  }
}


void dot_generator::generate_for_unit(const unit_props &unit) {
  registry_unit &regunit = registry_[unit];

  for (element_defs::iterator it = regunit.elements_.begin();
       it != regunit.elements_.end(); ++it) {
    ostm_ << escape(it->first) << "_element -> " << escape(it->second.type_) << ";" << std::endl;
    ostm_ << escape(it->first) << "_element"
	  << " [ label=" << quote(it->first) << ", shape=box ]" << std::endl;
    generate_tree(it->second.type_);
  }

//   ostm_ << " { rank=same;";
//   for (name_resolver::iterator it = regunit.elements_.begin();
//        it != regunit.elements_.end(); ++it) {
//     ostm_ << escape(it->first) << "_element;";
//   }
//   ostm_ << "}" << std::endl;

}

void dot_generator::generate() {
  begin_dot_file();
  for (unit_array::iterator it = registry_.units_.begin();
       it != registry_.units_.end(); ++it)
    generate_for_unit(*it);
  end_dot_file();
}
