/* -*- c++ -*- */
#ifndef OSIXAKA2_AKAXISONIZER_H__
#define OSIXAKA2_AKAXISONIZER_H__

#include <osixaka2/processor.h>

namespace osx {

  class akaxisonizer {
    registry &registry_;
    registry_unit &regunit_;
    bool verbose_;

    bool simplify_class(class_def *def);
    bool simplify_children(class_def *def);
    bool simplify_one_element_type(class_def *def);
    void add_missings_for_class(class_def *def);
    bool add_member_number(aka::qname &name, const std::string &prefix, int index);
    void fix_anonymous_member_name(aka::qname &name);
    void fix_member_name(class_def *def);
    void rename_duplicate_member(class_def *def);
    aka::qname define_array(const aka::qname &valuename);
    bool array_required(const element_type &etype) const;
    bool array_required(const class_def &def) const;

    bool is_ptrmember(const element_type &etype) const;
    bool is_array(const element_type &etype) const;
    bool occ_required(const element_type &etype) const;

    void set_array_properties(const class_def *def, element_type &etype);
    bool replace_any(element_type &etype);
    bool replace_any(const aka::qname &type, element_type &etype);
    bool replace_builtin(element_type &etype);
  public:
    akaxisonizer(registry &reg, registry_unit &regunit, bool verbose)
      : registry_(reg), regunit_(regunit), verbose_(verbose){}
    void add_missings();
    void optimize(); 
    void akaxisonize();
  };
}

#endif
