#include "xiso.h"

void member_leaf::model() {
  member("name", &::member::name_, xiso::leaf<std::string>());
  member("title", &::member::title_, xiso::leaf<std::string>());
}

void members_leaf::model() {
  member("member", &::members::members_, members_type_leaf(),0, aka::unbounded);
}

void project_leaf::model() {
  member("project_name", &::project::project_name_, xiso::leaf<std::string>());
  member("url", &::project::url_, xiso::leaf<std::string>());
  member("members", &::project::members_, members_leaf());
}

void instantiate_xiso() {
  aka::doctype("member", member_leaf());
  aka::doctype("members", members_leaf());
  aka::doctype("project", project_leaf());
  aka::doctype("project_name", xiso::leaf<std::string>());
  aka::doctype("url", xiso::leaf<std::string>());
}

void serialize(const member &root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "member", ostm);
}

void serialize(const members &root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "members", ostm);
}

void serialize(const project &root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "project", ostm);
}

void serialize(const std::string &root, std::ostream &ostm, const std::string &docname) {
  aka::xml_serializer ser;
  ser.serialize(root, docname, ostm);
}


