// -*- c++ -*-
#ifndef PROJECT_H__
#define PROJECT_H__

#include <akaxiso2/content_model.h>
#include <list>

namespace pj {

  struct Member {
    Member(){}
    Member(const std::string &name, const std::string &title) 
      : name_(name), title_(title){}

    const std::string &get_name() const { return name_; }
    void set_name(const std::string &name) { name_ = name; }
    const std::string &get_title() const { return title_; }
    void set_title(const std::string &title) { title_ = title; }

  private:
    std::string name_;
    std::string title_;
  };

  typedef std::list<Member> Members;

  struct Team {
    std::string name_;
    std::string url_;
    const Members &get_members() const { return members_; }
    void set_members(const Members &members) { members_ = members; }

  private:
    Members members_;
  };

}

namespace xiso {

  template<>
  struct leaf<pj::Member> : public aka::sequence<pj::Member> {
    void model() {

#if !defined(_MSC_VER)
      accessor("cuppa:name", 
	       aka::ref_getter(&pj::Member::get_name), 
	       aka::ref_setter(&pj::Member::set_name), 
	       leaf<std::string>());
      accessor("cuppa:title", 
	       aka::ref_getter(&pj::Member::get_title), 
	       aka::ref_setter(&pj::Member::set_title), 
	       leaf<std::string>());

#else /** Use below for VC6 */ 
       typedef aka::_ref_getter<pj::Member, std::string> string_getter;
       typedef aka::_ref_setter<pj::Member, std::string> string_setter;
       accessor("cuppa:name", 
 	       string_getter(&pj::Member::get_name), 
 	       string_setter(&pj::Member::set_name), 
 	       leaf<std::string>());
       accessor("cuppa:title", 
 	       string_getter(&pj::Member::get_title), 
 	       string_setter(&pj::Member::set_title), 
 	       leaf<std::string>());
#endif
    }
  };

  template<>
  struct leaf<pj::Members> : public aka::sequential_array<pj::Members> {  };

  template<>
  struct leaf<pj::Team> : public aka::sequence<pj::Team> {
    void model() {
      member("cuppa:project_name", &pj::Team::name_);
      member("cuppa:url", &pj::Team::url_);
      enclose("cuppa:members");

#if !defined(_MSC_VER)
      ; accessor("cuppa:member", 
                 aka::ref_getter(&pj::Team::get_members),
                 aka::ref_setter(&pj::Team::set_members),
                 leaf<pj::Members>(), 0, aka::unbounded);

#else      /** Use below for VC6 */
      ; accessor("cuppa:member", 
                 aka::_ref_getter<pj::Team, pj::Members>(&pj::Team::get_members), 
                 aka::_ref_setter<pj::Team, pj::Members>(&pj::Team::set_members),
                 leaf<pj::Members>(), 0, aka::unbounded);
#endif

      disclose("cuppa:members");
    }
  };
}

#endif
