/* -*- c++ -*- */
#ifndef AKAXISO2_UTIL_MUTEX_H__
#define AKAXISO2_UTIL_MUTEX_H__

#include <akaxiso2/configuration.h>

#ifdef AKAXISO2_USE_PTHREAD

#include <pthread.h>

namespace aka2 {

  class mutex {
  public:
    mutex();
    ~mutex();
    void lock();
    void unlock();
  private:
    pthread_mutex_t mutex_;
  };

}

#endif // AKAXISO2_USE_PTHREADS



/** Mutex for WIN32 */
#ifdef _WIN32

#include <winbase.h>

namespace aka2 {

  class mutex {
  public:
    mutex();
    ~mutex();
    void lock();
    void unlock();
  private:
    CRITICAL_SECTION critical_section_;
  };

}  

#endif

#endif
