#include "preconditions.h"
#include "namespace_statics.h"
#include "namespaces.h"
#include "../util/string_funcs.h"


namespace aka2 {
  aka2::preconditions g_pcd_;
}

using namespace aka2;

void aka2::reset_for_new_document() {
  g_pcd_.reset_for_new_document();
}

preconditions::preconditions() {
  prefixes_ = shared_ptr<prefix_map>(new prefix_map());
}

preconditions::~preconditions() {
  clear_properties();
}

shared_ptr<preconditions> preconditions::clone(bool clone_prefixes) const {
  preconditions *ret = new preconditions();
  if (clone_prefixes)
    ret->prefixes_ = shared_ptr<prefix_map>(new prefix_map(*prefixes_));
  else
    ret->prefixes_ = shared_ptr<prefix_map>(new prefix_map());
  return shared_ptr<preconditions>(ret); 
}

void preconditions::clear_all() {
  if (prefixes_ != 0)
    prefixes_->clear();
  id_constraint_.clear();
  clear_properties();
}

void preconditions::reset_for_new_document() const {
  id_constraint_.clear();
  for (properties::const_iterator it = properties_.begin();
       it != properties_.end(); ++it) {
    const precondition &con = it->second;
    con.reset_for_new_document();
  }
}


void preconditions::add_property_ptr(const std::string &name, void *p, 
				     property_operator *prop_op) {
  precondition con(p, prop_op);
  std::pair<properties::iterator, bool> res = 
    properties_.insert(properties::value_type(name, con));
  if (!res.second)
    throw error("Precondition property " + quote(name) + " is already added.",
		__FILE__, __LINE__);
}

void *preconditions::get_property_ptr(const std::string &name) const {
  properties::const_iterator it = properties_.find(name);
  if (it == properties_.end())
    throw error("Property " + quote(name) + " not found.", __FILE__, __LINE__);
  return it->second.property_;
}

const void *preconditions::const_get_property_ptr(const std::string &name) const {
  return get_property_ptr(name);
}

void preconditions::clear_properties() {
  properties_.clear();
}

bool preconditions::check_id(const std::string &value) const {
  if (id_constraint_.find(value) != id_constraint_.end())
    return false;
  const_cast<preconditions*>(this)->id_constraint_.insert(value);
  return true;
}
