/* -*- c++ -*- */
#ifndef AKAXISO2_FRAMEWORK_MEMBERTYPE_H__
#define AKAXISO2_FRAMEWORK_MEMBERTYPE_H__

#include <akaxiso2/framework/member.h>
#include <akaxiso2/framework/element_props.h>
#include <akaxiso2/util/shared_ptr.h>
#include <map>

#include <assert.h>

namespace aka2 {

  class member_type : public element_props {
  public:
    member_type() : mgetter_(0) {}
    member_type(const member_getter *getter, const element_op &op) 
      : element_props(op), mgetter_(getter) {}

    const member_getter &getter() const { return *mgetter_; }
    bool equals(const void *lhs, const void *rhs) const;
    bool empty() const { return mgetter_.get() == 0; }
    void set_member_to_default(void *e) const;
  protected:
    shared_ptr<const member_getter> mgetter_;
  };

  class attribute_type : public member_type  {
  public:
    attribute_type() : required_(false) {}
    attribute_type(const member_getter *mgetter, const element_op &op);
    attribute_type(const member_getter *mgetter);

    void set_required(bool val) {
      assert(default_.get() != 0); // Simpletype always have default_op.
      required_ = val;
    }

    void set_value_attr(const std::string &defval) { 
      default_->set_default(defval); 
    }

    bool is_required() const { return required_; }
    bool is_attribute_default(const void *e) const;
  private:
    bool required_;

    // Hide occurence related method.
    occurrence &set_occurrence(const occurrence &occ);
    const occurrence &get_occurrence() const;
  };

  struct member_types : public std::vector<member_type> {};
  struct member_map : public std::map<qname, member_type, qname_less> {};
  struct attribute_types : public std::vector<attribute_type> {};
}

#endif
