#include "any_op.h"
#include "type_registry.h"
#include "membertype.h"

using namespace aka2;

wildcard_op wildcard_op::dispatcher_;
any_op any_op::dispatcher_;
attribute_type wildcard_op::attributes_;
any_array_op any_array_op::dispatcher_;


bool wildcard_attributes_op::equals(const void *lhs, const void *rhs) const {
  const wc_attributes& lattrs = *static_cast<const wc_attributes*>(lhs);
  const wc_attributes& rattrs = *static_cast<const wc_attributes*>(rhs);

  if (lattrs.size() != rattrs.size())
    return false;
  
  wc_attributes::const_iterator lit = lattrs.begin();
  wc_attributes::const_iterator rit = rattrs.begin();

  while ((lattrs.end() != lit) && (rattrs.end() != rit)) {
    bool res = (lit->name_ == rit->name_) &&
      (lit->value_ == rit->value_);
    if (!res)
      return false;
    ++lit;
    ++rit;
  }
  assert((lattrs.end() == lit) && (rattrs.end() == rit));
  return true;
}




wildcard_attributes_op wildcard_attributes_op::dispatcher_;

bool wildcard_op::equals(const void *lhs, const void *rhs) const {
  const wildcard &lwc = *static_cast<const wildcard*>(lhs);
  const wildcard &rwc = *static_cast<const wildcard*>(rhs);

  if (lwc.name_ != rwc.name_)
    return false;

  if (!wildcard_attributes_op::dispatcher_.equals(&lwc.attributes_, &rwc.attributes_))
    return false;

  if (lwc.children_.size() != rwc.children_.size())
    return false;
  
  // No children.  compare value_, and return.
  if (lwc.children_.empty() && rwc.children_.empty())
    return (lwc.value_ == rwc.value_);

  wc_array::const_iterator lit = lwc.children_.begin();
  wc_array::const_iterator rit = rwc.children_.begin();
  while ((lwc.children_.end() != lit) /* && (rany.end() != rit)*/) {
    if (!wildcard_op::dispatcher_.equals(&*lit, &*rit))
      return false;
    ++lit;
    ++rit;
  }
  return true;
}

void wildcard_op::initialize() {
  if (!system_type_registry().add(wildcard_op()))
    return;

  member_getter *getter = 
    create_ptr_getter(static_cast<const wildcard*>(0), &wildcard::attributes_);
  attributes_ = attribute_type(getter);
  attributes_.set_ns_list("##any");
}

void wildcard_op::uninitialize() {
  attributes_ = attribute_type();
}




bool any_op::equals(const void *lhs, const void *rhs) const {
  const any& lany = *static_cast<const any*>(lhs);
  const any& rany = *static_cast<const any*>(rhs);

  if (!lany.document_.empty() && !rany.document_.empty())
    return lany.document_ == rany.document_;

  if (lany.document_.empty() || rany.document_.empty())
    return false;

  return wildcard_op::dispatcher_.equals(&lany.wc_, &rany.wc_);
}


void any_op::initialize() {
  if (!system_type_registry().add(any_op()))
    return;
}

void any_op::uninitialize() {}


bool any_array_op::equals(const void *lhs, const void *rhs) const {
  const any_array& larray = *static_cast<const any_array*>(lhs);
  const any_array& rarray = *static_cast<const any_array*>(rhs);

  if (larray.size() != rarray.size())
    return false;
  
  any_array::const_iterator lit = larray.begin();
  any_array::const_iterator rit = rarray.begin();

  while ((larray.end() != lit) && (rarray.end() != rit)) {
    bool res = any_op::dispatcher_.equals(&*lit, &*rit);
    if (!res)
      return false;
  }
  assert((larray.end() == lit) && (rarray.end() == rit));
  return true;
}


void any_array_op::initialize() {
  if (!system_type_registry().add(any_array_op()))
    return;
}

void any_array_op::uninitialize() {}
