/* -*- c++ -*- */
#ifndef AKAXISO2_CONFIGURATION_H__
#define AKAXISO2_CONFIGURATION_H__

#define AKAXISO2_PACKAGE "akaxiso2"
#define AKAXISO2_VERSION "2.0-beta2"

#ifdef __unix__
# include <akaxiso2/config.h>
# define AKAXISO2_USE_PTHREAD 1
 /** Use windows sjis map for unix other than MacOS X. */
# define __BBL_LOAD_UNICODE_MAP_CP932__
# define __BBL_USE_UNICODE_MAP_CP932__
#endif

# ifdef __APPLE_CC__
# include <akaxiso2/config.h>
# define AKAXISO2_USE_PTHREAD 1
/** Use apple sjis map for MacOS X. */
# define __BBL_LOAD_UNICODE_MAP_APPLE__
# define __BBL_USE_UNICODE_MAP_APPLE__
# define __BBL_USING_STDMAP_TABLE__
# define __BIG_ENDIAN_COMPUTER__
#endif


/* Make sure to define _WIN32 for BCB. */
#if defined(__WIN32__) /* BCB style */ && !defined(_WIN32)
# define _WIN32 1
#endif

#ifdef _WIN32
# include <akaxiso2/config_win32.h>
# include <windows.h>
#endif


/** Compilers */

#ifdef __GNUC__
# define TYPENAME typename
# define LONGLONG long long
# define ULONGLONG unsigned long long
# define AKAXISO2_USE_OWN_USTRING 1
# define WCHAR_T aka2::uchar_t
# if (__GNUC__ == 3) && (__GNUC_MINOR__ <= 3)
#  define IMPLEMENT_CHAR_TRAITS 1
# endif
# if (__GNUC__ == 2) && (__GNUC_MINOR__ == 96)
#  define MISSING_SSTREAM_IN_IOSFWD 1
# endif
# if (__GNUC__ == 2) && (__GNUC_MINOR__ == 95)
#  define AKAXISO2_USE_ISTRSTREAM 1
# endif
# if defined(__i386__)
#  define __LITTLE_ENDIAN_COMPUTER__ 1
# endif
# if defined(sparc)
#  define __BIG_ENDIAN_COMPUTER__
# endif
# ifndef __BBL_USING_STDMAP_TABLE__
#  define __BBL_USING_STATIC_TABLE__ 1 // babel
# endif
#endif

#ifdef _MSC_VER
# pragma warning( disable : 4786 )
# if _MSC_VER >= 1300
#  define TYPENAME typename
# else
#  define TYPENAME
# endif
# ifndef LONGLONG
#  define LONGLONG _int64
# endif
# ifndef ULONGLONG
#  define ULONGLONG unsigned _int64
# endif
# ifdef _M_IX86
#  define __LITTLE_ENDIAN_COMPUTER__
# endif
# define __BBL_USING_STATIC_TABLE__ 1 // babel
# define WCHAR_T wchar_t
#endif

#ifdef __BORLANDC__
# define TYPENAME typename
# if __BORLANDC__ >= 0x0560
#  define LONGLONG long long
#  define ULONGLONG unsigned long long
# endif
# ifdef AKAXISO2_USE_XERCESC
#  pragma link "XercesLib.lib"
# endif
# define __LITTLE_ENDIAN_COMPUTER__ 1
# define __BBL_USING_STATIC_TABLE__ 1 // babel
# define WCHAR_T wchar_t
#endif

/** Encoding macros. */
#ifdef AKAXISO2_EUCJP
# define __USING_EUC__ 1 // Babel
# undef AKAXISO2_EUCJP
#endif

#ifdef AKAXISO2_UTF8
# define __USING_UTF8__ 1 // Babel
# undef AKAXISO2_UTF8
#endif

#ifdef AKAXISO2_SJIS
# define __USING_SJIS__ 1 // Babel
# undef AKAXISO2_SJIS
#endif

/* babel '#define's. */
#define __BBL_USE_SELECTORS__      1
#define __UNICODE_CHAR_SIZE_2__    1


#ifndef WCHAR_T
# error "Wide string type(WCHAR_T) is not specified."
#endif

#if !defined(AKAXISO2_DEFAULT_ENCODING)
# error "Default encoding is not specified."
#endif

#if !defined(__LITTLE_ENDIAN_COMPUTER__) && !defined(__BIG_ENDIAN_COMPUTER__)
# error "Endian is not specified."
#endif

#if defined(__LITTLE_ENDIAN_COMPUTER__) && defined(__BIG_ENDIAN_COMPUTER__)
# error "Both endian BIG/LITTLE are specified at the sametime."
#endif

#if !defined(AKAXISO2_USE_XERCESC) && !defined(AKAXISO2_USE_EXPAT)
# error "XML parser is not specified."
#endif

#endif
