/* -*- c++ -*- */
#ifndef AKAXISO2_XML_EXPAT_EXPAT_DESERIALIZER_H__
#define AKAXISO2_XML_EXPAT_EXPAT_DESERIALIZER_H__

/**
 * @file akaxiso2/XML/expat/expat_deserializer.h
 * @brief XML deserializer by using expat SAX parser.
 */

#include <akaxiso2/configuration.h>
#ifdef AKAXISO2_USE_EXPAT

#include <akaxiso2/XML/deserializer/deserializer.h>
#include <akaxiso2/imported/expat_parser.h>

namespace aka2 {

  /** @brief XML deserializer by using expat SAX parser. */
  class expat_deserializer : public deserializer {
  public:
    expat_deserializer() { }
    ~expat_deserializer() { }

    virtual document deserialize(std::istream &istm);
    virtual document deserialize(const char *doc);
    virtual document deserialize(const std::string &doc);
    virtual document deserialize_stdin();
    virtual document deserialize_file(const std::string &filename);

  private:
    document deserialize_chars(const char *buffer, int len,
			       const std::string &source_name);
    document deserialize_istream(std::istream &istm, const std::string &source_name);
  };

} // namespace aka2

#endif

#endif
