#include "encoding_name.h"
#include "../akaxiso2/exception.h"

namespace {

  /**
   * Encoding name entries.
   */

  const char *euc_names[] = {
    "EUC-JP",
    "EUCJP",
    0
  };

  const char *jis_names[] = {
    "JIS",
    "ISO-2022-JP",
    "ISO2022-JP",
    "ISO-2022JP",
    "ISO2022JP",
    0
  };

  const char *sjis_names[] = {
    "ShiftJIS",
    "SJIS",
    "Shift_JIS",
    "Shift-JIS",
    0
  };

  const char* utf16_names[] = {
    "UTF-16",
    "UTF16",
    0
  };

  const char* utf16be_names[] = {
    "UTF-16BE",
    "UTF16BE",
    0
  };

  const char* utf16le_names[] = {
    "UTF-16LE",
    "UTF16LE",
    0
  };

  const char* utf8_names[] = {
    "UTF-8",
    "UTF8",
    0
  };

  bool find_encoding_name(const char **names, const std::string &encoding) {
    for (const char** index = names; *index != 0; ++index) {
      if (strcasecmp(*index, encoding.c_str()) == 0)
	return true;
    }
    return false;
  }

}

  
bool aka2::is_binary_encoding(const std::string &encoding) {
  if (find_encoding_name(utf16_names, encoding))
    return true;
  if (find_encoding_name(utf16be_names, encoding))
    return true;
  if (find_encoding_name(utf16le_names, encoding))
    return true;
  return false;
}
  

std::string aka2::canonicalize_encoding_name(const std::string &encoding) {
  if (find_encoding_name(euc_names, encoding))
    return euc_names[0];
  if (find_encoding_name(jis_names, encoding))
    return jis_names[0];
  if (find_encoding_name(sjis_names, encoding))
    return sjis_names[0];
  if (find_encoding_name(utf16_names, encoding))
    return utf16_names[0];
  if (find_encoding_name(utf16be_names, encoding))
    return utf16be_names[0];
  if (find_encoding_name(utf16le_names, encoding))
    return utf16le_names[0];
  if (find_encoding_name(utf8_names, encoding))
    return utf8_names[0];

  throw aka2::tagged_error("encoding", encoding, "not found.", __FILE__, __LINE__);

  return "";
}
