/* -*- c++ -*- */
#ifndef AKAXISO2_XML_DESERIALIZER_WILDCARD_HANDLER_H__
#define AKAXISO2_XML_DESERIALIZER_WILDCARD_HANDLER_H__

/** @file akaxiso2/parser/wildcard_handler.h */

#include <akaxiso2/XML/deserializer/handler.h>

namespace aka2 {

  class wildcard_handler : public handler {
  public:
    wildcard_handler(wildcard &an, int depth,
		     const qname& tagname, const element_props &props,
		     parser_context &context);
    virtual ~wildcard_handler();

    virtual validation_result query_element(const qname &tagname, const attribute_values &attrs);
    virtual validation_result end_element(const qname &tagname);
    virtual validation_result query_next(const qname &tagname, const attribute_values &attrs);
    virtual bool parse_entity(const std::string &entity);

    virtual node get_node();
    virtual void receive_child(const node &child);
    virtual bool can_skip();
    virtual void abort();
    
  private:
    wildcard &wc_;
    wildcard *child_;
  };
  
  
} // namespace aka2

#endif
