//CUPPA:include=+
//CUPPA:include=-
#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/TestAssert.h>

#include <akaxiso/akaxiso.h>
#include <akaxiso/content_model.h>

#include <iostream>

//CUPPA:namespace=+
//CUPPA:namespace=-


namespace {

  struct simple_value {
    std::string attribute_;
    std::string value_;
  };

  class simple_value_leaf : public aka::simplecontent<simple_value, simple_value_leaf> {
  public:
    void model() {
      xmltype("simple_value");
      value(&simple_value::value_, xiso::leaf<std::string>());
      attribute("attribute", &simple_value::attribute_);
    }
  };


  struct fixed_value_sc {
    std::string attribute_;
  };

  class fixed_value_sc_leaf : public aka::simplecontent<fixed_value_sc, fixed_value_sc_leaf> {
  public:
    void model() {
      xmltype("fixed_value_sc");
      fixed_value<std::string>("fixed", xiso::leaf<std::string>());
      attribute("attribute", &fixed_value_sc::attribute_);
    }
  };


  class fixed_sc_leaf : public aka::simplecontent<aka::nill, fixed_sc_leaf> {
  public:
    void model() {
      xmltype("fixed_sc");
      fixed_value<std::string>("fixed", xiso::leaf<std::string>());
      fixed_attribute<std::string>("attribute", "test");
    }
  };

}


class simpleContentTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(simpleContentTest);
//CUPPA:suite=+
  CPPUNIT_TEST(test_equality0);
  CPPUNIT_TEST(test_equality1);
  CPPUNIT_TEST(test_copy);
  CPPUNIT_TEST(test_serialize);
  CPPUNIT_TEST(test_parse);
  CPPUNIT_TEST(test_fixed_value_sc_equality0);
  CPPUNIT_TEST(test_fixed_value_sc_equality1);
  CPPUNIT_TEST(test_fixed_value_sc_copy);
  CPPUNIT_TEST(test_fixed_value_sc_serialize);
  CPPUNIT_TEST(test_fixed_value_sc_parse);
  CPPUNIT_TEST(test_fixed_sc_equality0);
  CPPUNIT_TEST(test_fixed_sc_copy);
  CPPUNIT_TEST(test_fixed_sc_serialize);
  CPPUNIT_TEST(test_fixed_sc_parse);
//CUPPA:suite=-
  CPPUNIT_TEST_SUITE_END();
private:

public:

  virtual void setUp() { 
    aka::initialize();
    aka::doctype("mydoc", simple_value_leaf());
    aka::doctype("fixed_value_sc", fixed_value_sc_leaf());
    aka::doctype("fixed_sc", fixed_sc_leaf());
  }

  virtual void tearDown(){
    aka::uninitialize();
  }

  static simple_value get_simple_value(){
    simple_value sv;
    sv.value_ = "Test String for a SimpleContent.";
    sv.attribute_ = "Attribute test";
    return sv;
  }

  static fixed_value_sc get_fixed_value_sc(){
    fixed_value_sc fs;
    fs.attribute_ = "Attribute test";
    return fs;
  }

//CUPPA:decl=+

  void test_equality0(){
    simple_value sim = get_simple_value();
    simple_value sim1 = get_simple_value();
    bool eq = aka::equals(sim, sim1, simple_value_leaf());
    CPPUNIT_ASSERT_MESSAGE("Equality test failed.", eq);
  }

  void test_equality1(){
    simple_value sim = get_simple_value();
    simple_value sim1 = get_simple_value();

    sim.value_ = "Test";
    bool eq = aka::equals(sim, sim1, simple_value_leaf());
    CPPUNIT_ASSERT_MESSAGE("Equality test failed.", !eq);
  }


  void test_copy() {
    simple_value sim = get_simple_value();
    simple_value sim1;
    aka::copy_element(sim1, sim, simple_value_leaf());
    bool eq = aka::equals(sim, sim1, simple_value_leaf());
    CPPUNIT_ASSERT_MESSAGE("Simuence::CopyTo failed.", eq);
  }

  void test_serialize() {
    std::ostringstream ostm;
    simple_value sim = get_simple_value();
    aka::xml_serializer ser;
    ser.serialize(sim, "mydoc", ostm);
//      std::cout << ostm.rdbuf()->str() << std::endl;
  }

  void test_parse() {
    std::ostringstream ostm;
    simple_value sim = get_simple_value();
    aka::xml_serializer ser;
    ser.serialize(sim, "mydoc", ostm);

    aka::document doc = aka::deserialize(ostm.rdbuf()->str());
    CPPUNIT_ASSERT_MESSAGE("Wrong tagname.", aka::document_of(doc, "mydoc"));

    simple_value *parsed = aka::root_cast<simple_value>(doc);

    bool eq = aka::equals(sim, *parsed, simple_value_leaf());
    if (!eq) {
      aka::serialize(doc, ostm);
      std::cout << ostm.str();
    }
    CPPUNIT_ASSERT_MESSAGE("Parsed document is not the same as original.", eq);
  }


  void test_fixed_value_sc_equality0(){
    fixed_value_sc sim = get_fixed_value_sc();
    fixed_value_sc sim1 = get_fixed_value_sc();
    bool eq = aka::equals(sim, sim1, fixed_value_sc_leaf());
    CPPUNIT_ASSERT_MESSAGE("Equality test failed.", eq);
  }

  void test_fixed_value_sc_equality1(){
    fixed_value_sc sim = get_fixed_value_sc();
    fixed_value_sc sim1 = get_fixed_value_sc();

    sim.attribute_ = "Test";
    bool eq = aka::equals(sim, sim1, fixed_value_sc_leaf());
    CPPUNIT_ASSERT_MESSAGE("Equality test failed.", !eq);
  }


  void test_fixed_value_sc_copy() {
    fixed_value_sc sim = get_fixed_value_sc();
    fixed_value_sc sim1;
    aka::copy_element(sim1, sim, fixed_value_sc_leaf());
    bool eq = aka::equals(sim, sim1, fixed_value_sc_leaf());
    CPPUNIT_ASSERT_MESSAGE("Simuence::CopyTo failed.", eq);
  }

  void test_fixed_value_sc_serialize() {
    std::ostringstream ostm;
    fixed_value_sc sim = get_fixed_value_sc();
    aka::xml_serializer ser;
    ser.serialize(sim, "fixed_value_sc", ostm);
//      std::cout << ostm.rdbuf()->str() << std::endl;
  }

  void test_fixed_value_sc_parse() {
    std::ostringstream ostm;
    fixed_value_sc sim = get_fixed_value_sc();
    aka::xml_serializer ser;
    ser.serialize(sim, "fixed_value_sc", ostm);

    aka::document doc = aka::deserialize(ostm.rdbuf()->str());
    CPPUNIT_ASSERT_MESSAGE("Wrong tagname.", aka::document_of(doc, "fixed_value_sc"));

    fixed_value_sc *parsed = aka::root_cast<fixed_value_sc>(doc);

    bool eq = aka::equals(sim, *parsed, fixed_value_sc_leaf());
    if (!eq) {
      aka::serialize(doc, ostm);
      std::cout << ostm.str();
    }
    CPPUNIT_ASSERT_MESSAGE("Parsed document is not the same as original.", eq);
  }

  void test_fixed_sc_equality0(){
    aka::nill n1, n2;
    bool eq = aka::equals(n1, n2, fixed_sc_leaf());
    CPPUNIT_ASSERT_MESSAGE("Equality test failed.", eq);
  }

  void test_fixed_sc_copy() {
    aka::nill sim, sim1;
    aka::copy_element(sim1, sim, fixed_sc_leaf());
    bool eq = aka::equals(sim, sim1, fixed_sc_leaf());
    CPPUNIT_ASSERT_MESSAGE("Simuence::CopyTo failed.", eq);
  }

  void test_fixed_sc_serialize() {
    std::ostringstream ostm;
    aka::nill n1;
    aka::xml_serializer ser;
    ser.serialize(n1, "fixed_sc", ostm);
//      std::cout << ostm.rdbuf()->str() << std::endl;
  }

  void test_fixed_sc_parse() {
    std::ostringstream ostm;
    aka::nill n1;
    aka::xml_serializer ser;
    ser.serialize(n1, "fixed_sc", ostm);

    aka::document doc = aka::deserialize(ostm.rdbuf()->str());
    CPPUNIT_ASSERT_MESSAGE("Wrong tagname.", aka::document_of(doc, "fixed_sc"));

    aka::nill *parsed = aka::root_cast<aka::nill>(doc);

    bool eq = aka::equals(n1, *parsed, fixed_sc_leaf());
    if (!eq) {
      aka::serialize(doc, ostm);
      std::cout << ostm.str();
    }
    CPPUNIT_ASSERT_MESSAGE("Parsed document is not the same as original.", eq);
  }

//CUPPA:decl=-
};

//CUPPA:impl=+
//CUPPA:impl=-

CPPUNIT_TEST_SUITE_REGISTRATION(simpleContentTest);
