#include <akaxiso/akaxiso.h>
#include "sample.h"
#include <iostream>
#include <stdlib.h> /* {BCB6}:exit */

int main(int argc, char* argv[]){
  
  // initialize akaxiso.
  aka::initialize();
  // initialize XML typeinfo classes.
  instantiate_xiso();

  // deserialize
  aka::document doc;
  try {
    doc = aka::deserialize(std::cin);
  }
  catch (const aka::error &e) {
    std::cerr << e.what() << std::endl;
    std::cerr << "Parse error detected.  Abort immediately." << std::endl;
    exit(1);
  }
  catch ( ... ) {
    std::cerr << "Unhandled parse error detected.  Abort immediatedly." << std::endl;
    exit(1);
  }

  std::cerr << "Document name is " << doc.get_name() << "." << std::endl;
  /*
    Get the root node of document.
    YourDoc *ydoc = aka::root_cast<YourDoc>(doc);
  */

  {
    aka::xml_serializer ser;
    ser.serialize(doc, std::cout);
  }
  // Uninitializers.
  aka::uninitialize();

  return 0;
}
