#include <akaxiso/akaxiso.h>
#include <iostream>

/** 
 *  element.h generated by osixaka2 has decarations 
 *  for element classes and serialization functions.
 */
#include "element.h"

int main(int argc, char* argv[]){
  
  // initialize akaxiso library.
  aka::initialize();
  // instantiate xiso::leaf classes to allow xs:schema to be deserialized.
  //  xs::instantiate_xiso();
  instantiate_xiso();

  // parsing from stdin.
  aka::document doc;
  try {
    doc = aka::deserialize(std::cin);
  }
  catch (const aka::error &e) {
    std::cerr << e.what() << std::endl;
    std::cerr << "Parse error detected.  Abort immediately." << std::endl;
    exit(1);
  }
  catch ( ... ) {
    std::cerr << "Unhandled parse error detected.  Abort immediatedly." << std::endl;
    exit(1);
  }

  // serialization of schema instance to std::cout.
//   aka2::serialize(doc, std::cout);

  // Uninitialize akaxiso to release global resources.
  aka::uninitialize();

  return 0;
}
