/* -*- c++ -*- */
#ifndef OSIXAKA_REGISTRY_H__
#define OSIXAKA_REGISTRY_H__

#include <akaxiso/akaxiso.h>
#include "classdefs.h"
#include "name_resolver.h"

namespace osx {
  struct preference;
}

struct registry {
  class_defs classes_;
  attrGroup_defs attributeGroups_;
  std::vector<aka::id_type> ns_order_;

  name_resolver elements_;
  name_resolver attributes_;
  name_resolver simpleTypes_;
  qname_set toplevels_;

  registry() : preference_(0) { }
  ~registry();

  bool type_exists(const aka::qname &type) const;
  bool name_exists(const aka::qname &name) const;
  void get_predefinedTypes(qname_set &resolved) const;
  aka::qname rename_type(const aka::qname &type) const;

  void insert_simpleTypes();

  bool is_toplevel(const aka::qname &name) const;
  bool is_predefined(const aka::qname &name) const;
  bool is_any(const aka::qname &name) const;
  bool is_builtin(const aka::qname &tyname) const;

  std::string get_predefined_leafname(const aka::qname &name) const;
  aka::qname get_predefined_array(const aka::qname &name) const;

  std::string escape(const std::string &to_escape) const;

  void load_defaults();
  void save_preference(std::ostream &ostm);
  void load_preference(std::istream &ostm);
  void register_ns();

  const std::string &choice_container_type() const;
  const std::string &array_container_type() const;
  const std::string &get_member_prefix() const;
  const std::string &get_member_postfix() const;
  const std::string &get_array_prefix() const;
  const std::string &get_array_postfix() const;
  const std::string &get_nill_type() const;

  static void initialize();

private:
  osx::preference *preference_;
  static std::string to_cppname(const std::string &name);
};

#endif
