#include "registry.h"
#include "preference.h"

namespace {
  
  struct system_builtin {
    const char *name_;
    const char *cpp_;
  };

  const system_builtin akaxiso_system_builtins[] = {
    // Must not be replaced.
//     {"xs:anyType", "aka:any"},
//     {"xs:anySimpleType", "std:string"},
    {"aka:any", "aka:any"},
    {"aka:any_array", "aka:any_array"},
    {0}
  };
}


using namespace osx;

void registry::insert_simpleTypes() {
  type_array::iterator it;

  type_array &aka_builtins = preference_->cpp_builtins_.type_;
  for (it = aka_builtins.begin(); it != aka_builtins.end(); ++it)
    simpleTypes_.replace(aka::qname(it->name_), aka::qname(it->cpp_));

  type_array &osx_builtins = preference_->schema_builtins_.type_;
  for (it = osx_builtins.begin(); it != osx_builtins.end(); ++it)
    simpleTypes_.replace(aka::qname(it->name_), aka::qname(it->cpp_));
}

bool registry::type_exists(const aka::qname &type) const {
  return attributeGroups_.exists(type) || classes_.exists(type);
}

bool registry::name_exists(const aka::qname &name) const {
  return elements_.exists(name)
    || attributes_.exists(name)
    || simpleTypes_.exists(name);
}

aka::qname registry::rename_type(const aka::qname &tyname) const {
  type_array::const_iterator tit; // iterator for type.
  const type_array &aka_builtins = preference_->cpp_builtins_.type_;
  for (tit = aka_builtins.begin(); tit != aka_builtins.end(); ++tit) {
    if (aka::qname(tit->name_) == tyname)
      return aka::qname(tit->cpp_);
  }

  substitution_array::const_iterator sit; // iterator for substitution.
  const substitution_array &substitutions = preference_->substitution_;
  for (sit = substitutions.begin(); sit != substitutions.end(); ++sit) {
    if (tyname.local() == sit->original_)
      return aka::qname(tyname.get_uri_id(), sit->substituted_);
  }
  return tyname;
}


bool registry::is_predefined(const aka::qname &tyname) const {
  const system_builtin *ty;
  for (ty = akaxiso_system_builtins; ty->name_ != 0; ++ty) {
    if (aka::qname(ty->name_) == tyname)
      return true;
  }

  type_array::const_iterator it;

  const type_array &aka_builtins = preference_->cpp_builtins_.type_;
  for (it = aka_builtins.begin(); it != aka_builtins.end(); ++it)
    if (aka::qname(it->name_) == tyname)
      return true;
  const type_array &osx_builtins = preference_->schema_builtins_.type_;
  for (it = osx_builtins.begin(); it != osx_builtins.end(); ++it)
    if (aka::qname(it->name_) == tyname)
      return true;
  return false;
}

bool registry::is_builtin(const aka::qname &tyname) const {
  type_array::const_iterator it;

  const type_array &aka_builtins = preference_->cpp_builtins_.type_;
  for (it = aka_builtins.begin(); it != aka_builtins.end(); ++it)
    if (aka::qname(it->name_) == tyname)
      return true;
  return false;
}

std::string registry::get_predefined_leafname(const aka::qname &tyname) const {
  type_array::const_iterator it;

  const type_array &aka_builtins = preference_->cpp_builtins_.type_;
  for (it = aka_builtins.begin(); it != aka_builtins.end(); ++it){
    if (aka::qname(it->name_) == tyname) {
      return std::string("xiso::leaf<") + to_cppname(it->cpp_) + ">";
    }
    else if (aka::qname(it->array_) == tyname) {
      if (!it->array_leaf_.get() != 0)
	return *it->array_leaf_;
      return to_cppname(it->array_) + "_leaf";
    }
  }

  const type_array &osx_builtins = preference_->schema_builtins_.type_;
  for (it = osx_builtins.begin(); it != osx_builtins.end(); ++it) {
    if (aka::qname(it->name_) == tyname) {
      if (it->leaf_.get() != 0)
	return to_cppname(*it->leaf_);
      return std::string("xiso::leaf<") + to_cppname(it->cpp_) + ">";
    }
    else if (aka::qname(it->array_) == tyname) {
      if (it->array_leaf_.get() != 0)
	return to_cppname(*it->array_leaf_);
      return to_cppname(it->array_) + "_leaf";
    }
  }

  assert(!"Must not reach here.");
  return std::string();
}


bool registry::is_toplevel(const aka::qname &name) const {
  return toplevels_.find(name) != toplevels_.end();
}


void registry::get_predefinedTypes(qname_set &qnames) const {
  const system_builtin *ty;
  for (ty = akaxiso_system_builtins; ty->name_ != 0; ++ty) {
    qnames.insert(aka::qname(ty->name_));
  }

  type_array::const_iterator it;

  const type_array &aka_builtins = preference_->cpp_builtins_.type_;
  for (it = aka_builtins.begin(); it != aka_builtins.end(); ++it) {
    qnames.insert(aka::qname(it->name_));
    qnames.insert(aka::qname(it->array_));
  }

  const type_array &osx_builtins = preference_->schema_builtins_.type_;
  for (it = osx_builtins.begin(); it != osx_builtins.end(); ++it) {
    qnames.insert(aka::qname(it->name_));
    qnames.insert(aka::qname(it->array_));
  }
}


aka::qname registry::get_predefined_array(const aka::qname &name) const {

  type_array::const_iterator it;

  const type_array &aka_builtins = preference_->cpp_builtins_.type_;
  for (it = aka_builtins.begin(); it != aka_builtins.end(); ++it)
    if (aka::qname(it->name_) == name)
      return aka::qname(it->array_);

  const type_array &osx_builtins = preference_->schema_builtins_.type_;
  for (it = osx_builtins.begin(); it != osx_builtins.end(); ++it)
    if (aka::qname(it->name_) == name)
      return aka::qname(it->array_);

  assert(!"Must not reach here.");
  return aka::qname();
}

bool registry::is_any(const aka::qname &name) const {
  return name == aka::qname("aka:any")
    || name == aka::qname("aka:any_array");
}

std::string registry::escape(const std::string &to_escape) const {
  std::string escaped = to_escape;
  
  escape_array::const_iterator it;
  const escape_array &escapes = preference_->escape_;
  for (it = escapes.begin(); it != escapes.end(); ++it) {
    bool replaced;
    do {
      replaced = false;
      std::string::size_type pos = escaped.find(it->to_escape_);
      if (pos != std::string::npos) {
	std::string::size_type len = std::string(it->to_escape_).size();
	escaped = escaped.substr(0, pos) + it->escaped_ + 
	  escaped.substr(pos + len);
	replaced = true;
      }
    } while (replaced);
  } 
  return escaped;
}

void registry::register_ns() {
  namespace_array &namespaces = preference_->namespace_;
  for (namespace_array::iterator it = namespaces.begin(); it != namespaces.end(); ++it)
    aka::xmlns(it->prefix_, it->uri_);
}


std::string registry::to_cppname(const std::string &name) {
  aka::qname qn(name);
  if (qn.is_qualified())
    return qn.prefix() + "::" + qn.local();
  return qn.local();
}

void registry::save_preference(std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(*preference_, "osx:preference", ostm);
}

void registry::load_preference(std::istream &istm) {
  aka::document doc = aka::deserialize(istm);
  preference_ = aka::adopt_root<osx::preference>(doc);
}

void registry::initialize() {
  osx::instantiate_xiso();
}

const std::string &registry::choice_container_type() const {
  return preference_->choice_container_.type_;
}

const std::string &registry::array_container_type() const {
  return preference_->array_container_.type_;
}

const std::string &registry::get_member_prefix() const {
  return preference_->member_format_.prefix_;
}

const std::string &registry::get_member_postfix() const {
  return preference_->member_format_.postfix_;
}

const std::string &registry::get_array_prefix() const {
  return preference_->array_format_.prefix_;
}

const std::string &registry::get_array_postfix() const {
  return preference_->array_format_.postfix_;
}

const std::string &registry::get_nill_type() const {
  return preference_->nill_type_;
}
