/* -*- c++ -*- */
#ifndef preference_xiso_h__
#define preference_xiso_h__

#include "preference.h"
#include <akaxiso/content_model.h>

namespace osx {

  struct container_type_leaf : aka::sequence< ::osx::container_type, container_type_leaf> {
    void model();
  };

  struct escape_leaf : aka::sequence< ::osx::escape, escape_leaf> {
    void model();
  };

  struct format_leaf : aka::sequence< ::osx::format, format_leaf> {
    void model();
  };

  struct _namespace_leaf : aka::sequence< ::osx::_namespace, _namespace_leaf> {
    void model();
  };

  struct nill_type_leaf : aka::sequence< ::osx::nill_type, nill_type_leaf> {
    void model();
  };

  struct substitution_leaf : aka::sequence< ::osx::substitution, substitution_leaf> {
    void model();
  };

  struct substitution;
  typedef aka::sequential_array< ::osx::substitution_array, ::osx::substitution_leaf> substitution_array_leaf;

  struct escape;
  typedef aka::sequential_array< ::osx::escape_array, ::osx::escape_leaf> escape_array_leaf;

  struct _namespace;
  typedef aka::sequential_array< ::osx::namespace_array, ::osx::_namespace_leaf> namespace_array_leaf;

  struct type_leaf : aka::sequence< ::osx::type, type_leaf> {
    void model();
  };

  struct type;
  typedef aka::sequential_array< ::osx::type_array, ::osx::type_leaf> type_array_leaf;

  struct types_leaf : aka::sequence< ::osx::types, types_leaf> {
    void model();
  };

  struct preference_leaf : aka::sequence< ::osx::preference, preference_leaf> {
    void model();
  };


}
#endif // #ifndef preference_xiso_h__
