#include "preference_xiso.h"
#include <akaxiso/akaxiso.h>
#include <akaxiso/schema/schema_builtin_xiso.h>

namespace osx {

  void container_type_leaf::model() {
    /** attribute member definition. */
    attribute("type", &::osx::container_type::type_, xiso::leaf<std::string>()).required(true);
  }

  void escape_leaf::model() {
    /** attribute member definition. */
    attribute("to_escape", &::osx::escape::to_escape_, xiso::leaf<std::string>()).required(true);
    attribute("escaped", &::osx::escape::escaped_, xiso::leaf<std::string>()).required(true);
  }

  void format_leaf::model() {
    /** attribute member definition. */
    attribute("prefix", &::osx::format::prefix_, xiso::leaf<std::string>()).required(true);
    attribute("postfix", &::osx::format::postfix_, xiso::leaf<std::string>()).required(true);
  }

  void _namespace_leaf::model() {
    /** attribute member definition. */
    attribute("prefix", &::osx::_namespace::prefix_, xiso::leaf<std::string>()).required(true);
    attribute("uri", &::osx::_namespace::uri_, xiso::leaf<std::string>()).required(true);
  }

  void nill_type_leaf::model() {
  /** element member definitions */
    member("cpp", &::osx::nill_type::cpp_, xiso::leaf<std::string>());
    ptrmember("leaf", &::osx::nill_type::leaf_, xiso::leaf<std::string>());
    member("array", &::osx::nill_type::array_, xiso::leaf<std::string>());
    ptrmember("array_leaf", &::osx::nill_type::array_leaf_, xiso::leaf<std::string>());
  }

  void substitution_leaf::model() {
    /** attribute member definition. */
    attribute("original", &::osx::substitution::original_, xiso::leaf<std::string>()).required(true);
    attribute("substituted", &::osx::substitution::substituted_, xiso::leaf<std::string>()).required(true);
  }

  void type_leaf::model() {
  /** element member definitions */
    member("cpp", &::osx::type::cpp_, xiso::leaf<std::string>());
    ptrmember("leaf", &::osx::type::leaf_, xiso::leaf<std::string>());
    member("array", &::osx::type::array_, xiso::leaf<std::string>());
    ptrmember("array_leaf", &::osx::type::array_leaf_, xiso::leaf<std::string>());
    /** attribute member definition. */
    attribute("name", &::osx::type::name_, xiso::leaf<std::string>());
  }

  void types_leaf::model() {
  /** element member definitions */
    member("type", &::osx::types::type_, ::osx::type_array_leaf(), 0, aka::unbounded);
  }

  void preference_leaf::model() {
  /** element member definitions */
    member("choice_container", &::osx::preference::choice_container_, ::osx::container_type_leaf());
    member("array_container", &::osx::preference::array_container_, ::osx::container_type_leaf());
    member("member_format", &::osx::preference::member_format_, ::osx::format_leaf());
    member("array_format", &::osx::preference::array_format_, ::osx::format_leaf());
    member("substitution", &::osx::preference::substitution_, ::osx::substitution_array_leaf(), 0, aka::unbounded);
    member("escape", &::osx::preference::escape_, ::osx::escape_array_leaf(), 0, aka::unbounded);
    member("namespace", &::osx::preference::namespace_, ::osx::namespace_array_leaf(), 0, aka::unbounded);
    member("nill_type", &::osx::preference::nill_type_, xiso::leaf<std::string>());
    member("cpp_builtins", &::osx::preference::cpp_builtins_, ::osx::types_leaf());
    member("schema_builtins", &::osx::preference::schema_builtins_, ::osx::types_leaf());
  }

  void instantiate_xiso() {
    aka::xmlns("osx", "http://akaxiso.sourceforge.jp/osixaka/preference");
    aka::doctype("osx:preference", ::osx::preference_leaf());
  }

}

void serialize(const ::osx::preference& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "osx:preference", ostm);
}

