#include "preference.h"
#include "registry.h"

namespace {

  struct ns_decl {
    const char *prefix_;
    const char *uri_;
  };

  ns_decl ns_decls[] = {
    {"wsdl", "http://schemas.xmlsoap.org/wsdl/"},
    {0}
  };
  
  struct default_type {
    const char *name_;
    const char *cpp_;
    const char *leaf_;
    const char *array_;
    const char *array_leaf_;
  };

  const default_type akaxiso_builtins[] = {
    {"xs:byte",          "char",          0, "aka:char_array",      0},
    {"xs:unsignedByte",  "unsigned char", 0, "aka:uchar_array",     0},
    {"xs:short",         "short",         0, "aka:short_array",     0},
    {"xs:unsignedShort", "short",         0, "aka:short_array",     0},
    {"xs:int",           "long",          0, "aka:long_array",      0},
    {"xs:unsignedInt",   "ULONGLONG",     0, "aka:longlong_array",  0},
    {"xs:long",          "LONGLONG",      0, "aka:longlong_array",  0},
    {"xs:unsignedLong",  "ULONGLONG",     0, "aka:ulonglong_array", 0},
    {"xs:integer",       "long",          0, "aka:long_array",      0},
    {"xs:boolean",       "bool",          0, "aka:bool_array",      0},
    {"xs:float",         "float",         0, "aka:float_array",     0},
    {"xs:double",        "double",        0, "aka:double_array",    0},
    {"xs:string",        "std:string",    0, "aka:string_array",    0},
    {"xs:anySimpleType", "std:string",    0, "aka:string_array",    0},
    // empty-value type provided by akaxiso. 
    {"aka:nill",         "aka:nill",      0, "aka:nill_array",      0}, 
    {0}
  };

  const default_type xs_builtins[] = {
    {"xs:normalizedString",   "std:string", 0,              "xs:normalizedString_array",   0},
    {"xs:token",              "std:string", 0,              "xs:token_array",              0},
    {"xs:base64Binary",       "std:string", 0,              "xs:base64Binary_array",       0},
    {"xs:hexBinary",          "std:string", 0,              "xs:hexBinary_array",          0},
    {"xs:positiveInteger",    "long",       0,              "xs:positiveInteger_array",    0},
    {"xs:negativeInteger",    "long",       0,              "xs:negativeInteger_array",    0},
    {"xs:nonNegativeInteger", "long",       0,              "xs:nonNegativeInteger_array", 0},
    {"xs:nonPositiveInteger", "long",       0,              "xs:nonPositiveInteger_array", 0},
    {"xs:decimal",            "long",       0,              "xs:decimal_array",            0},
    {"xs:time",               "std:string", 0,              "xs:time_array",               0},
    {"xs:dateTime",           "std:string", 0,              "xs:dateTime_array",           0},
    {"xs:duration",           "std:string", 0,              "xs:duration_array",           0},
    {"xs:date",               "std:string", 0,              "xs:date_array",               0},
    {"xs:gMonth",             "std:string", 0,              "xs:gMonth_array",             0},
    {"xs:gYear",              "std:string", 0,              "xs:gYear_array",              0},
    {"xs:gYearMonth",         "std:string", 0,              "xs:gYearMonth_array",         0},
    {"xs:gDay",               "std:string", 0,              "xs:gDay_array",               0},
    {"xs:gMonthDay",          "std:string", 0,              "xs:gMonthDay_array",          0},
    {"xs:Name",               "std:string", 0,              "xs:Name_array",               0},
    {"xs:QName",              "aka:qname",  "xs:QNameLeaf", "xs:QName_array",              0},
    {"xs:NCName",             "std:string", 0,              "xs:NCName_array",             0},
    {"xs:anyURI",             "std:string", 0,              "xs:anyURI_array",             0},
    {"xs:language",           "std:string", 0,              "xs:language_array",           0},
    {"xs:ID",                 "std:string", 0,              "xs:ID_array",                 0},
    {"xs:IDREF",              "std:string", 0,              "xs:IDREF_array",              0},
    {"xs:IDREFS",             "std:string", 0,              "xs:IDREFS_array",             0},
    {"xs:ENTITY",             "std:string", 0,              "xs:ENTITY_array",             0},
    {"xs:ENTITIES",           "std:string", 0,              "xs:ENTITIES_array",           0},
    {"xs:NOTATION",           "std:string", 0,              "xs:NOTATION_array",           0},
    {"xs:NMTOKEN",            "std:string", 0,              "xs:NHMTOKEN_array",           0},
    {"xs:NMTOKENS",           "std:string", 0,              "xs:NMTOKENS_array",           0},
    {0}
  };

  struct default_substitution {
    const char *original_;
    const char *substituted_;
  };

  const default_substitution default_substitutions[] = {
    {"class",     "_class"},
    {"public",    "_public"},
    {"protected", "_protected"},
    {"private",   "_private"},
    {"union",     "_union"},
    {"enum",      "_enum"},
    {"namespace", "_namespace"},
    {"using",     "_using"},
    {0}
  };
  
  struct default_escape {
    const char *to_escape_;
    const char *escaped_; 
  };

  const default_escape default_escapes[] = {
    {"-", "_"},
    {0}
  };
}

using namespace osx;

registry::~registry() {
  if (preference_)
    delete preference_;
}

void registry::load_defaults() {

  if (preference_)
    delete preference_;

  preference_ = new preference();
//   aka::construct_element(*preference_, osx::preference_leaf());

  preference_->member_format_.prefix_ = "";
  preference_->member_format_.postfix_ = "_";

  preference_->array_format_.prefix_ = "";
  preference_->array_format_.postfix_ = "_array";

  // Container types.
  preference_->choice_container_.type_ = "std::list";
  preference_->array_container_.type_ = "std::list";

  // loading defaults for namespaces.
  preference_->namespace_.clear();
  for (const ns_decl *ns = ns_decls; ns->prefix_ != 0; ++ns) {
    _namespace ns_element;
    ns_element.prefix_ = ns->prefix_;
    ns_element.uri_ = ns->uri_;
    preference_->namespace_.push_back(ns_element);
  }

  preference_->nill_type_ = "aka:nill";

  const default_type *ty;
  
  type_array &abuiltins_element = preference_->cpp_builtins_.type_;
  for (ty = akaxiso_builtins; ty->name_ != 0; ++ty) {
    type t;
    t.name_ = ty->name_;
    t.cpp_ = ty->cpp_;
    if (ty->leaf_ != 0)
      t.leaf_.reset(new std::string(ty->leaf_));
    t.array_ = ty->array_;
    if (ty->array_leaf_ != 0)
      t.array_leaf_.reset(new std::string(ty->leaf_));

    abuiltins_element.push_back(t);
  }
  
  type_array &xsbuiltins_element = preference_->schema_builtins_.type_;
  for (ty = xs_builtins; ty->name_ != 0; ++ty) {
    type t;
    t.name_ = ty->name_;
    t.cpp_ = ty->cpp_;
    if (ty->leaf_ != 0)
      t.leaf_.reset(new std::string(ty->leaf_));
    t.array_ = ty->array_;
    if (ty->array_leaf_ != 0)
      t.array_leaf_.reset(new std::string(ty->leaf_));

    xsbuiltins_element.push_back(t);
  }

  substitution_array &sub_elms = preference_->substitution_;
  for (const default_substitution *sub = default_substitutions; 
       sub->original_ != 0; ++sub) {
    substitution sub_elm;
    sub_elm.original_ = sub->original_;
    sub_elm.substituted_ = sub->substituted_;
    sub_elms.push_back(sub_elm);
  }

  escape_array &escapes = preference_->escape_;
  for (const default_escape *es = default_escapes; es->to_escape_ != 0; ++es) {
    osx::escape es_elm;
    es_elm.to_escape_ = es->to_escape_;
    es_elm.escaped_ = es->escaped_;
    escapes.push_back(es_elm);
  }
}
