#ifdef _MSC_VER
# pragma warning( disable : 4786 )
#endif

#if defined(__unix__) || defined(__linux__)
# include <unistd.h>
#else
  extern "C" int getopt (int argc, char *const *argv, const char *shortopts);
# include "getopt.h"
#endif

#include <akaxiso/akaxiso.h>
#include <akaxiso/schema/schema_xiso.h>
#include <akaxiso/schema/schema.h>

#include <iostream>
#include <iomanip>
#include <fstream>
#include <stdlib.h>

#include "osixaka.h"


void usage() {

  std::cout << "osixaka (" << AKAXISO_PACKAGE << "-" << AKAXISO_VERSION << ")" << std::endl
	    << " XMLSchema compiler for akaxiso2." << std::endl
	    << " usage  osixaka2 [-p] [-d] [-v] [-h] [-o output directory] [Schema files...]" 
	    << std::endl
	    << "  -d: dump parsed document." << std::endl
	    << "  -p: just parse XMLSchema document." << std::endl
	    << "  -o: specify output directory to write generated files." << std::endl
	    << "  -v: verbose mode." << std::endl
	    << " Preference" << std::endl
	    << "  -S: save preference to a specified file." << std::endl
	    << "  -L: load preference from a specified file." << std::endl
 	    << " DTD options." << std::endl
 	    << "  -D: convert DTD to XML-Schema." << std::endl
	    << "  -h: show this message." << std::endl;
}


int main(int argc, char* argv[]){

  aka::initialize();
  osixaka::initialize();

  std::ostream &logstm = std::cout;
  std::string outputdir = "./";
  std::string preference_path;
  bool dtd_ = false;
  bool parse_only = false;
  bool do_dump = false;
  bool verbose = false;
  bool save_preference = false;

  char c;
  while ((c = getopt(argc, argv, "dpo:vS:L:Dh")) != -1) {
    switch (c) {
    case 'd': {
      do_dump = true;
      break;
    }
    case 'p': {
      do_dump = true;
      parse_only = true;
      break;
    }
    case 'o': {
      outputdir = optarg;
      if (outputdir.at(outputdir.size()) != '/')
	outputdir += "/";
      break;
    }
    case 'v': {
      verbose = true;
      break;
    }
    case 'S' : {
      preference_path = optarg;
      save_preference = true;
      break;
    }
    case 'L' : {
      preference_path = optarg;
      break;
    }
    case 'D': {
      dtd_ = true;
      parse_only = true;
      do_dump = true;
      break;
    }
    case 'h' : {
      usage();
      exit(0);
    }
    default: {
      logstm << "Unknown option." << std::endl;
      exit(1);
    }
    }
  }

  osixaka osx(std::cerr, do_dump, verbose);

  /** loading preference. */
  if (save_preference) {
    std::ofstream file(preference_path.c_str());
    if (!file) {
      std::cerr << "Failed to open file." << std::endl;
      exit(1);
    }
    osx.load_defaults();
    osx.save_preference(file);
    file.close();
    exit(0);
  }

  if (preference_path.empty())
    osx.load_defaults();
  else {
    try {
      std::ifstream file(preference_path.c_str());
      osx.load_preference(file);
    }
    catch (const std::exception &e) {
      std::cerr << e.what() << std::endl
                << "Failed to load preference." << std::endl;
      exit(1);
    }
  }

  if (optind == argc) {
    logstm << "No document for generation." << std::endl;
    usage();
    exit(1);
  }

  for (int docindex = optind; docindex < argc; ++docindex) {

    if (dtd_) {
      if (osx.process_dtd(argv[docindex]) != 0) {
	logstm << "Failed to process DTD declaration, " << argv[docindex] << "." << std::endl;
	exit(1);
      }
    }
    else {
      if (osx.deserialize(argv[docindex]) != 0) {
	logstm << "Faild to parse document, " << argv[docindex] << std::endl;
	exit(1);
      }
    }

    if (parse_only)
      continue;

    if (osx.process() != 0) {
      logstm << "Failed to process document, " << argv[docindex] << std::endl;
      exit(1);
    }
  }

  if (parse_only)
    exit(0);

  try {
    osx.akaxisonize();
    osx.generate(outputdir);
  }
  catch (const std::exception &e) {
    logstm << e.what() << std::endl
	   << "Error found.  Generation aborted." << std::endl;
    exit(1);
  }

  logstm << "Generation completed." << std::endl;
    
  // Uninitializers.
  aka::uninitialize();
  return 0;
}
