/* -*- c++ -*- */
#ifndef AKAXISO_SCHEMA_SCHEMA_BUILTIN_XISO_H__
#define AKAXISO_SCHEMA_SCHEMA_BUILTIN_XISO_H__

#include <akaxiso/framework/builtin_xiso.h>
#include <akaxiso/schema/schema_builtin.h>

namespace xs {
  
  struct QNameLeaf : aka::simpletype<QName, QNameLeaf> {
    static void read_text(void *elm, aka2::isstream &istm, 
			  const aka::preconditions &pcd);
  };
  
  struct QNameRefLeaf : aka::simpletype<QName, QNameRefLeaf> {
    static void read_text(void *elm, aka2::isstream &istm, 
			  const aka::preconditions &pcd);
  };


  typedef aka::sequential_array<base64Binary_array> base64Binary_array_leaf;
  typedef aka::sequential_array<hexBinary_array> hexBinary_array_leaf;

  typedef aka::sequential_array<string_array> string_array_leaf;
  typedef aka::sequential_array<normalizedString_array> normalizedString_array_leaf;
  typedef aka::sequential_array<token_array> token_array_leaf;

  typedef aka::sequential_array<positiveInteger_array> positiveInteger_array_leaf;
  typedef aka::sequential_array<negativeInteger_array> negativeInteger_array_leaf;
  typedef aka::sequential_array<nonPositiveInteger_array> nonPositiveInteger_array_leaf;
  typedef aka::sequential_array<nonNegativeInteger_array> nonNegativeInteger_array_leaf;
  typedef aka::sequential_array<decimal_array> decimal_array_leaf;

  typedef aka::sequential_array<time_array> time_array_leaf;
  typedef aka::sequential_array<dateTime_array> dateTime_array_leaf;
  typedef aka::sequential_array<duration_array> duration_array_leaf;
  typedef aka::sequential_array<date_array> date_array_leaf;
  typedef aka::sequential_array<gMonth_array> gMonth_array_leaf;
  typedef aka::sequential_array<gYear_array> gYear_array_leaf;
  typedef aka::sequential_array<gYearMonth_array> gYearMonth_array_leaf;
  typedef aka::sequential_array<gDay_array> gDay_array_leaf;
  typedef aka::sequential_array<gMonthDay_array> gMonthDay_array_leaf;
  typedef aka::sequential_array<Name_array> Name_array_leaf;
  typedef aka::sequential_array<QName_array>  QName_array_leaf;
  typedef aka::sequential_array<NCName_array> NCName_array_leaf;
  typedef aka::sequential_array<anyURI_array> anyURI_array_leaf;
  typedef aka::sequential_array<language_array> language_array_leaf;
  typedef aka::sequential_array<ID_array> ID_array_leaf;
  typedef aka::sequential_array<IDREF_array> IDREF_array_leaf;
  typedef aka::sequential_array<IDREFS_array> IDREFS_array_leaf;
  typedef aka::sequential_array<ENTITY_array> ENTITY_array_leaf;
  typedef aka::sequential_array<ENTITIES_array> ENTITIES_array_leaf;
  typedef aka::sequential_array<NOTATION_array> NOTATION_array_leaf;
  typedef aka::sequential_array<NMTOKEN_array> NMTOKEN_array_leaf;
  typedef aka::sequential_array<NMTOKENS_array> NMTOKENS_array_leaf;

  
}

namespace xiso {
  template<>
  struct leaf<xs::QName> : xs::QNameLeaf { };
}

#endif
