/* -*- c++ -*- */
#ifndef XS_SCHEMA_SCHEMA_BUILTIN_H__
#define XS_SCHEMA_SCHEMA_BUILTIN_H__

#include <akaxiso/framework/builtin.h>
#include <akaxiso/framework/qname.h>

namespace xs {

  // Binary
  typedef std::string base64Binary;
  typedef std::string hexBinary;

  typedef std::string string;
  typedef std::string normalizedString;
  typedef std::string token;

  typedef long positiveInteger;
  typedef long negativeInteger;
  typedef long nonPositiveInteger;
  typedef long nonNegativeInteger;
  typedef long decimal;

  typedef std::string time;
  typedef std::string dateTime;
  typedef std::string duration;
  typedef std::string date;
  typedef std::string gMonth;
  typedef std::string gYear;
  typedef std::string gYearMonth;
  typedef std::string gDay;
  typedef std::string gMonthDay;
  typedef std::string Name;
  typedef aka::qname  QName;
  typedef std::string NCName;
  typedef std::string anyURI;
  typedef std::string language;
  typedef std::string ID;
  typedef std::string IDREF;
  typedef std::string IDREFS;
  typedef std::string ENTITY;
  typedef std::string ENTITIES;
  typedef std::string NOTATION;
  typedef std::string NMTOKEN;
  typedef std::string NMTOKENS;

  // arrays
  typedef std::vector<base64Binary> base64Binary_array;
  typedef std::vector<hexBinary> hexBinary_array;

  typedef std::vector<string> string_array;
  typedef std::vector<normalizedString> normalizedString_array;
  typedef std::vector<token> token_array;

  typedef std::vector<positiveInteger> positiveInteger_array;
  typedef std::vector<negativeInteger> negativeInteger_array;
  typedef std::vector<nonPositiveInteger> nonPositiveInteger_array;
  typedef std::vector<nonNegativeInteger> nonNegativeInteger_array;
  typedef std::vector<decimal> decimal_array;

  typedef std::vector<time> time_array;
  typedef std::vector<dateTime> dateTime_array;
  typedef std::vector<duration> duration_array;
  typedef std::vector<date> date_array;
  typedef std::vector<gMonth> gMonth_array;
  typedef std::vector<gYear> gYear_array;
  typedef std::vector<gYearMonth> gYearMonth_array;
  typedef std::vector<gDay> gDay_array;
  typedef std::vector<gMonthDay> gMonthDay_array;
  typedef std::vector<Name> Name_array;
  typedef std::vector<aka::qname>  QName_array;
  typedef std::vector<NCName> NCName_array;
  typedef std::vector<anyURI> anyURI_array;
  typedef std::vector<language> language_array;
  typedef std::vector<ID> ID_array;
  typedef std::vector<IDREF> IDREF_array;
  typedef std::vector<IDREFS> IDREFS_array;
  typedef std::vector<ENTITY> ENTITY_array;
  typedef std::vector<ENTITIES> ENTITIES_array;
  typedef std::vector<NOTATION> NOTATION_array;
  typedef std::vector<NMTOKEN> NMTOKEN_array;
  typedef std::vector<NMTOKENS> NMTOKENS_array;

}

#endif

