/* -*- c++ -*- */
#ifndef AKAXISO_FRAMEWORK_SIMPLECONTENT_H__
#define AKAXISO_FRAMEWORK_SIMPLECONTENT_H__

/** @file akaxiso/classes/simplecontent.h */

#include <akaxiso/framework/operators.h>
#include <akaxiso/framework/simpletype.h>
#include <akaxiso/framework/attribute.h>
#include <akaxiso/framework/construct.h>

namespace aka2 {

  template<class L>
  class simplecontent_op_dispatcher : public simplecontent_op {
  public:
    virtual schematype_id get_schematype() const { return simplecontent_id; }
    virtual std::string get_typename() const { return L::get_xmltype(); }
    /** creatable */
    virtual void construct(void *e) const {  L::construct(e); }
    virtual void copy_construct(void *e, const void *src) const { L::copy_construct(e, src); }
    virtual void destruct(void *e) const { L::destruct(e); }
    virtual size_t class_size() const { return L::class_size(); }
    virtual bool equals(const void *lhs, const void *rhs) const {
      return L::equals(lhs, rhs);
    }

    /** attribute_types getter. */
    virtual const attribute_types *get_attribute_types() const {
      return &L::attribute_types_;
    }
    virtual const any_member *get_anyattr_type() const {
      return L::get_anyattr_type();
    }
    virtual const member_type& get_valuetype() const { return L::value_type_; }

  };

  template<class L, class T>
  struct simplecontent_statics {
    static member_type value_type_;
    static simplecontent_op_dispatcher<L> dispatcher_;
    static aka2::occurrence occ_;
    static aka2::qname xmltype_;
  };

  template<class L, class T>
  member_type simplecontent_statics<L, T>::value_type_;

  template<class L, class T>
  aka::occurrence simplecontent_statics<L, T>::occ_;

  template<class L, class T>
  aka2::qname simplecontent_statics<L, T>::xmltype_;

  template<class L, class T>
  simplecontent_op_dispatcher<L> simplecontent_statics<L, T>::dispatcher_;


  template<class T, class L=xiso::leaf<T> >
  class simplecontent : public attributes<L, T>, public simplecontent_statics<L, T> {
  public:
    typedef T value_type;

    virtual ~simplecontent(){}

    static void initialize() {
      if (!system_type_registry().add(L()))
	return;
      L::attribute_types_.clear();
      member_getter *getter = new null_getter();
      L::value_type_ = member_type(getter, nill_leaf::dispatcher_);
      L l; l.model();
    }
    static void uninitialize() {
      L::attribute_types_.clear();
    }


    static void construct(void *e) {
      new (e) T();
      simplecontent_construct(e, L::dispatcher_);
    }
    static void copy_construct(void *e, const void *src) {
      new (e) T(*static_cast<const T*>(src));
    }
    static size_t class_size() { return sizeof(T); }
    static void destruct(void *elm) { static_cast<T*>(elm)->~T(); }


    static bool equals(const void *lhs, const void *rhs) {
      return simplecontent_equals(lhs, rhs, L::dispatcher_);
    }

    static element_op* get_attribute_dispatcher() { return &L::dispatcher_; }
    static default_op* create_default_op() { return 0; }

    // Helper class to define serializable member.
    template<class V, class P, class VL>
    static void value(V P::* m, const VL&) {
      VL::initialize();
      member_getter *getter =
	create_ptr_getter(reinterpret_cast<T*>(0), m);
      L::value_type_ = member_type(getter, VL::dispatcher_);
      default_op *defop = VL::create_default_op();
      if (defop != 0)
	L::value_type_.set_default_op(defop);
    }

    template<class V, class P>
    static void value(V P::* m) {
      value(m, xiso::leaf<V>());
    }

    static void xmltype(const std::string &name) {
      L::xmltype_ = aka2::qname(name);
    }

    // Helper class to define serializable member.
    template<class V>
    struct fixed_value {
      fixed_value(const std::string &fixed) {
	new_member(fixed, xiso::leaf<V>());
      }
      template<class VL>
      fixed_value(const std::string &fixed, const VL &) {
      	new_member(fixed, VL());
      }
    private:
      template<class VL>
      void new_member(const std::string &fixed, const VL&) {
      	VL::initialize();

	if (VL::dispatcher_.get_schematype() != simpletype_id)
	  throw tagged_error("simpleContent", L::get_xmltype(), 
			     "fixed value should be a simpleType.",
			     __FILE__, __LINE__);

  L::value_type_ = aka2::member_type(new null_getter(), aka2::fixed<VL>::dispatcher_);
	L::value_type_.set_name(aka2::qname("&value"));
    	default_op *defop = VL::create_default_op();
	if (defop != 0)
	  L::value_type_.set_default_op(defop);
	L::value_type_.setup_default_value(fixed);
      }
    };

    static void set_default(const std::string &defval) {
      if (L::value_type_.get_schematype() != simpletype_id)
	throw tagged_error("simpleContent", L::get_xmltype(), 
			   "default value should be a simpleType.",
			   __FILE__, __LINE__);
      L::value_type_.set_default(defval);
    }

    static std::string get_xmltype() {
      if (L::xmltype_.empty())
	return typeid(T).name();
      return L::xmltype_.qualified();
    }
  };

} // namespace aka2

#endif
