/* -*- c++ -*- */
#ifndef AKAXISO_FRAMEWORK_PTRMEMBER_H__
#define AKAXISO_FRAMEWORK_PTRMEMBER_H__

#include <akaxiso/util/deep_ptr.h>
#include <akaxiso/framework/operators.h>

namespace aka2 {

  template<class VL, class V>
  struct ptrmember_op_dispatcher : public ptrmember_op {
  public:
    virtual std::string get_typename() const { return VL::get_xmltype(); }
    virtual const element_op& get_value_op() const {
      return VL::dispatcher_;
    };
    virtual void *&dereference(void *elm) const { 
      V &pv = *static_cast<V*>(elm);
      return reinterpret_cast<void*&>(pv.get());
    }
    virtual const void *dereference(const void *elm) const { 
      const V &pv = *static_cast<const V*>(elm);
      return pv.get();
    }
    static ptrmember_op_dispatcher<VL, V> dispatcher_;
  };

  template<class VL, class V>
  ptrmember_op_dispatcher<VL, V> ptrmember_op_dispatcher<VL, V>::dispatcher_;

  template<class V, class VL>
  struct ptrmember_op_stub : ptrmember_op_dispatcher<VL, V> {
  };


}

#endif
