/* -*- c++ -*- */
#ifndef AKAXISO_BUILTIN_XISO_H__
#define AKAXISO_BUILTIN_XISO_H__

#include <akaxiso/configuration.h>
#include <akaxiso/util/iosfwd.h>
#include <akaxiso/framework/simpletype.h>
#include <akaxiso/framework/array.h>


namespace aka2 {
  /** leaf for builtin arrays. */
  typedef aka2::sequential_array<std::vector<aka2::nill> >  nill_array_leaf;
  typedef aka2::sequential_array<std::vector<char> > char_array_leaf;
  typedef aka2::sequential_array<std::vector<unsigned char> > uchar_array_leaf;
  typedef aka2::sequential_array<std::vector<short> > short_array_leaf;
  typedef aka2::sequential_array<std::vector<unsigned short> > ushort_array_leaf;
  typedef aka2::sequential_array<std::vector<long> > long_array_leaf;
  typedef aka2::sequential_array<std::vector<unsigned long> > ulong_array_leaf;
  typedef aka2::sequential_array<std::vector<LONGLONG> > longlong_array_leaf;
  typedef aka2::sequential_array<std::vector<ULONGLONG> > ulonglong_array_leaf;
  typedef aka2::sequential_array<std::vector<int> > int_array_leaf;
  typedef aka2::sequential_array<std::vector<bool> > bool_array_leaf;
  typedef aka2::sequential_array<std::vector<float> > float_array_leaf;
  typedef aka2::sequential_array<std::vector<double> > double_array_leaf;
  typedef aka2::sequential_array<std::vector<std::string> > string_array_leaf;
}

namespace xiso {

  template<> struct leaf<char> : public aka2::simpletype<char> {
    static void read_text(void *elm, aka2::isstream &istm, const aka2::preconditions &pcd);
    static void write_text(const void *elm, std::ostream &ostm, const aka2::preconditions &pcd);
  };

  template<> struct leaf<unsigned char> : public aka2::simpletype<unsigned char> {
    static void read_text(void *elm, aka2::isstream &istm, const aka2::preconditions &pcd);
    static void write_text(const void *elm, std::ostream &ostm, const aka2::preconditions &pcd);
  };

  template<> struct leaf<short>  : public aka2::simpletype<short>  {};
  template<> struct leaf<unsigned short>  : public aka2::simpletype<unsigned short>  {};
  template<> struct leaf<long>   : public aka2::simpletype<long>   {};
  template<> struct leaf<unsigned long>   : public aka2::simpletype<unsigned long>   {};

  template<> struct leaf<LONGLONG>   : public aka2::simpletype<LONGLONG>   {
    static void write_text(const void *elm, std::ostream &ostm, const aka2::preconditions &pcd);
  };

  template<> struct leaf<ULONGLONG>   : public aka2::simpletype<ULONGLONG>   {
    static void write_text(const void *elm, std::ostream &ostm, const aka2::preconditions &pcd);
  };


  template<> struct leaf<int>    : public aka2::simpletype<int>    {};

  template<> struct leaf<float>  : public aka2::simpletype<float>  {};
  template<> struct leaf<double> : public aka2::simpletype<double> {};

  template<> struct leaf<aka2::nill> : public aka2::nill_leaf {};

  template<>
  struct leaf<std::string> : public aka2::simpletype<std::string> {
    static void read_text(void *elm, aka2::isstream &istm, 
			  const aka2::preconditions &pcd);
  };

  template<>
  struct leaf<bool> : public aka2::simpletype<bool> {
  public:
    static void read_text(void *elm, aka2::isstream &istm,
                          const aka2::preconditions &pcd);
    static void write_text(const void *elm, std::ostream &ostm,
			   const aka2::preconditions &pcd);
  };

} // namespace xiso


#endif
