/* -*- c++ -*- */
#ifndef AKAXISO_EXCEPTION_H__
#define AKAXISO_EXCEPTION_H__

#include <exception>
#include <string>

namespace aka2 {
  
  struct error : public std::exception {
    error(const std::string &msg, const char *file, const unsigned long line);
    virtual ~error() throw();
    virtual const char *what() const throw();
  protected:
    error() {}
    std::string msg_;
  };

  struct tagged_error : public error {
    tagged_error(const std::string &caption, 
		 const std::string &tagname,
		 const std::string &msg, 
		 const char *file, const unsigned long line);
    virtual ~tagged_error() throw();
  };

}

#endif
