/* -*- c++ -*- */
#include "akaxiso.h"
#include "XML/serializer/formatter_base.h"
#include "framework/namespaces.h"
#include "framework/type_registry.h"
#include "framework/closure.h"
#include "framework/any.h"
#include "framework/namespace_statics.h"
#include "framework/any_op.h"
#include "framework/preconditions.h"

#ifdef USE_XERCESC
#include <xercesc/util/PlatformUtils.hpp> /* {Xerces-C++} */
#endif

using namespace aka2;

namespace {
  preconditions pcd_;
  document_factory  doc_factory_;
  type_registry     type_registry_;
  int init_count_ = 0;
}

const preconditions &aka2::system_preconditions() {
  return pcd_;
}

document_factory& aka2::system_document_factory() {
  return doc_factory_;
} 

type_registry &aka2::system_type_registry() {
  return type_registry_;
}


void aka2::initialize() {
  if (++init_count_ != 1)
    return;

#ifdef USE_BABEL
  babel::init_babel();
#endif

#ifdef USE_XERCESC
  xercesc::XMLPlatformUtils::Initialize();
#endif

  namespaces_   .initialize();
  doc_factory_  .clear();
  type_registry_.initialize();
  prefix_map    ::initialize();
  pfs_.clear();
  any_op        ::initialize();
  any_array_op  ::initialize();
}

void aka2::uninitialize() {
  if (init_count_ == 0 || --init_count_ != 0)
    return;

  any_op       ::uninitialize();
  any_array_op::uninitialize();
  namespaces_   .clear();
  pfs_.clear();
  doc_factory_  .clear();
  type_registry_.uninitialize();
  
#ifdef USE_XERCESC
  xercesc::XMLPlatformUtils::Terminate();
#endif
}
