/* -*- c++ -*- */
#ifndef AKAXISO_XML_XERCES_XERCES_SERIALIZER_H__
#define AKAXISO_XML_XERCES_XERCES_SERIALIZER_H__

#include <akaxiso/configuration.h>

#ifdef USE_XERCESC

#include <memory.h> /* {BCB6} */
#include <xercesc/util/TransService.hpp>
#include <akaxiso/util/scoped_ptr.h>
#include <akaxiso/XML/serializer/formatter_base.h>
#include <akaxiso/XML/serializer/xml_serializer_base.h>

namespace aka2 {

  class xerces_formatter : public formatter_base {
  public:
    xerces_formatter() 
      : in_transcoder_(0), out_transcoder_(0) {};
    virtual ~xerces_formatter() {}

  private:
    virtual void set_encoding(const std::string &encoding);
    virtual ustring lcp_to_ucs2(const std::string &source);
    virtual void write(const ustring &entity);
    void set_bom(const std::string &encoding);
    
    scoped_ptr<xercesc::XMLLCPTranscoder> in_transcoder_;
    scoped_ptr<xercesc::XMLTranscoder> out_transcoder_;
  };

  class xerces_serializer : public xml_serializer_base {
  public:
    xerces_serializer(const std::string &encoding = DEFAULT_ENCODING)
    : xml_serializer_base(encoding) {
      formatter_ = shared_ptr<formatter_base>(new xerces_formatter());
      formatter_->set_encoding(encoding);
    }
  };

} // namespace aka2

#endif // USE_XERCESC


#endif
