/* -*- c++ -*- */
#ifndef AKAXISO_XML_SERIALIZER_FORMATTER_BASE_H__
#define AKAXISO_XML_SERIALIZER_FORMATTER_BASE_H__

#include <akaxiso/util/iosfwd.h>
#include <akaxiso/util/ustring.h>
#include <akaxiso/XML/encoding_name.h>

namespace aka2 {

  struct bom {
    char chars_[16];
    unsigned int length_;
  };

  class formatter_base {
  public:
    formatter_base() : bom_(0), ostm_(0), fd_(-1) {}
    virtual ~formatter_base() {  }

    virtual void set_encoding(const std::string &encoding) = 0;

    void prepare(std::ostream &ostm);
    void finish();

    void write(const std::string &value);
    void write_attribute_entity(const std::string &entity);
    void write_text_entity(const std::string &entity);

  private:
    virtual ustring lcp_to_ucs2(const std::string &source) = 0;
    virtual void write(const ustring &entity) = 0;
    void write_entity(const std::string &entity, const int escape_index);
    void set_binary_mode_for_stdio();
    void revert_stream_mode();

  protected:
    const bom* bom_;
    const bom* check_bom(const std::string &encoding) const;
    std::ostream *ostm_;
  private:
    std::string encoding_;
    int saved_stream_mode_;
    int fd_;
  };

} // namespace aka2

#endif
