/** -*- c++ -*- */
#ifndef AKAXISO_XML_DESERIALIZER_FIXED_HANDLER_H__
#define AKAXISO_XML_DESERIALIZER_FIXED_HANDLER_H__

/** @file akaxiso/XML/deserializer/fixed_handler.h */

#include <akaxiso/XML/deserializer/handler.h>

namespace aka2 {

  class fixed_handler : public handler {
  public:
    fixed_handler(const qname& tagname, void *elm, const fixed_op &op, 
		  int depth, const element_props &props,
		  parser_context &context);

    virtual ~fixed_handler(){}
    virtual validation_result query_element(const qname &tagname, const attribute_values &attrs);
    virtual validation_result end_element(const qname &tagname);
    virtual validation_result query_next(const qname &tagname, const attribute_values &attrs);
    virtual bool parse_entity(const std::string &entity);

    virtual node get_node();
    virtual void receive_child(const node &child);
    virtual bool can_skip();
    virtual void abort();
  private:
    void *e_;
    const element_op &fop_;
    const element_props &props_;
  };

} // namespace aka2

#endif
