#include "fixed_handler.h"
#include "../../framework/fixed.h"

using namespace aka2;

fixed_handler::fixed_handler(const qname& tagname, 
			     void *e,
			     const fixed_op &fop,
			     int depth, const element_props &props,
			     parser_context &context) 
  : handler(context, depth, tagname), e_(e), fop_(fop), props_(props)  {
  if (e_ != 0) {
    fop.get_value_op().destruct(e_);
    fop.get_value_op().construct(e_);
  }
}

validation_result fixed_handler::query_element(const qname &tagname, const attribute_values &attrs) {
  assert(!"Must not be called.");
  return invalid;
}

validation_result fixed_handler::query_next(const qname &tagname, const attribute_values &attrs) {
  assert(!"Must not be called.");
  return invalid;
}

bool fixed_handler::parse_entity(const std::string &entity) {
  return props_.is_fixed_string(entity, context_.get_preconditions());
}

validation_result fixed_handler::end_element(const qname &tagname) {
  return ok;
}

node fixed_handler::get_node() {
  return node(e_, fop_);
}

void fixed_handler::receive_child(const node &child) {
  assert(!"Must not be called.");
}

bool fixed_handler::can_skip() {
  assert(!"Must not be called.");
  return false;
}

void fixed_handler::abort() {
}
